program GetMBRSample;
(*

 The DOS FDISK command creates a special sector on the very first hard disk
 sector ( head 0, track 0, sector 0 ) called the partition sector or the master
 boot record (MBR), this sector defines each partition's area and whether or
 not the partition is a bootable partition. This program shows the partition
 entries contained in the MBR sector for drive C.

*)

 uses crt, DMT;

 var
   MBRbuffer : MBRstruct;    { The MBRstruct data type is defined in the DMT unit }

   Partition : string[ 25 ];

   Count,
   Sector    : byte;

   Track     : word;

   DrvLetter : char;

procedure SplitSectTrack(  Sect,
                           Cyl     : byte;

                           var
                            Sector : byte;

                           var
                            Track  : word );

(*
   For hard disks the track is a 10 bits value, the lower 8 bits reside in
   the TRACK variable and the upper two bits reside in bits 7 and 8 of the
   SECTOR variable; the lower 6 bits of SECTOR contain the disk 's sector
   number.
*)

begin
  Sector := Sect and $3F;
  Track  := ( Sect and $C0 ) shl 2;
  track  := track + Cyl;
end;

begin
  Color( 7, 0 );
  clrscr;
  DrvLetter  := 'C';    (* Selected Hard Disk C *)

  (* Reads the MBR sector from the hard disk into a buffer. *)

  ReadSect( DrvLetter, 0, 0, 0, 1, addr( MBRbuffer ) );   { Call ReadSect procedure }

  if ( ErrFlag ) then
    begin
      writeln( #7 );
      writeln( 'Error accesing drive C:');
      writeln(ShowError( GetErrCode ) );
      GetEnter;
      exit;
    end;

  if ( MBRbuffer.MBRsignature <> $AA55 ) then
    begin
      writeln( #7, 'ERROR : Partition sector invalid.' );
      GetEnter;
      exit;
    end;

  writeln;
  writeln( '                   MASTER BOOT RECORD FOR DRIVE ', DrvLetter );
  writeln( ' Ŀ' );
  writeln( '               Operating   Partition Start   Partition End    Sectors ' );
  writeln( ' Part.# Boot  System type  Side Track SectorSide Track SectorAllocated' );
  writeln( ' Ĵ' );

  for Count := 1 to 4 do

   with MBRbuffer.PartEntries[ Count ] do
     begin
       write( '    ',Count,'  ');

       if BootableFlag = $80 then
         write (' Yes  ')
       else
         write (' No   ');

       case PartID of
         $00  : Partition := 'Not assigned  ';

         $01  : Partition := 'PRI DOS Fat12 ';

         $02,
         $03  : Partition := 'XENIX         ';

         $04  : Partition := 'PRI DOS Fat16 ';

         $05  : Partition := 'EXTENDED DOS  ';

         $06  : Partition := 'DOS > 32Mb    ';

         $DB  : Partition := 'CONCURRENT DOS';

         else
           Partition := 'Unknown type ';
       end;

       SplitSectTrack( StartSect, StartTrack, Sector, Track );

       write( '', Partition , '');
       write( StartHead : 3, Track : 5, Sector : 5, '    ');

       SplitSectTrack( EndSect, EndTrack, Sector, Track );
       write( EndHead : 3, Track : 5, Sector : 5, '    ' );

       writeln( InsComma( PartitionSectors ) : 9, '' );
     end;

  writeln( ' ' );

  GetEnter;
end.

