program GetBootSample;

(*

 Every DOS disk has a special sector called the boot sector responsible for
 loading DOS or displaying the "Non-System disk" error message. In addition,
 the boot sector contains information about the disk, such as the number of
 sectors, tracks, FATs, and so on. This program reads the boot sector for the
 drive specified.

*)

 uses crt, DMT;

 var
   BootSectBuffer : BootSectStruct;  { The BootSectStruct data type is defined in the DMT unit }

   LogDrvs        : ListOfDrvs;      { The ListOfDrvs data type is defined in the DMT unit }

   BPBbuffer      : DevParamsStruct; { The DevParamsStruct data type is defined in the DMT unit }

   BootSectors,
   StartbootSect,
   Head,
   Track,
   Sect           : word;

   HugeSectors    : longint;

   DrvsCount,
   Index          : byte;

   DrvLetter      : char;

begin
  Color( 7, 0 );
  clrscr;

  GetDrvs( LogDrvs, DrvsCount );   { Call GetDrvs procedure }

  write( #13#10, 'Select Drive ( ');

  for Index := 1 to DrvsCount do
    write( LogDrvs[ Index ], ': ' );

  write( ') [ :]' );

  gotoxy( wherex - 3, wherey );
  DrvLetter := upcase( readkey );
  writeln( DrvLetter );

  GetBPB( DrvLetter, BPBbuffer );  { Call GetBPB procedure }

  if ( ErrFlag ) then
    begin
      writeln( #7 );
      writeln( ShowError( GetErrCode ) );
    end
  else
    begin
      with BPBbuffer do
        begin

          (* Determines the number of boot sectors to read *)

          BootSectors := BootSects;

          (* Determines the start of the first boot sector *)

          StartbootSect := HiddenSects;

          (*
            Translates the logical boot sector number into a physical sector
            consisting of head, track, and sector numbers.
          *)

          Head  := ( StartbootSect div SectsPerTrack ) mod NumOfHeads;
          Track := StartbootSect div ( SectsPerTrack * NumOfHeads );
          Sect  := StartbootSect mod SectsPerTrack;
        end;

      (* Reads the boot sector from disk and place it into a buffer *)

      ReadSect( DrvLetter, Head, Track, Sect, BootSectors, addr( BootSectBuffer ) );

      with BootSectBuffer do
        begin

          if ( NumOfSects = 0 ) then
            HugeSectors := BigSects
          else
            HugeSectors := NumOfSects;

          clrscr;
          writeln('             BOOT SECTOR          ' );
          writeln;
          writeln(' Drive specified                : ', DrvLetter );
          writeln(' Disk was formatted with        : ', OemName );
          writeln(' Media descriptor code          : ', WrdToHex( MediaCode ),'h' ) ;
          writeln(' Bytes per sector               : ', BytesPerSect );
          writeln(' Sectors per cluster            : ', SectsPerClust );
          writeln(' Sectors per track              : ', SectsPerTrack );
          writeln(' Number of sectors on disk      : ', InsComma( HugeSectors ) );
          writeln(' Number of heads (sides)        : ', NumOfHeads );
          writeln(' Number of hidden sectors       : ', HiddenSects );
          writeln(' Number of boot sectors         : ', BootSects );
          writeln(' Number of FAT copies           : ', NumOfFATs );
          writeln(' Sectors used by each FAT       : ', SectsPerFAT );
          writeln(' Maximum root-directory entries : ', RootDirEntries );
          write  (' First hard disk?               : ' );

          if ( DrvNumber = $80 ) then
            writeln( 'YES' )
          else
            writeln( 'NO' );

          if ( ExtBootSign = $29 ) then
            begin
              writeln(' Disk serial number             : ', WrdToHex( DskSerialNum2 ), '-', WrdToHex( DskSerialNum1 ) );
              writeln(' Disk volume name               : ', VolLabel );
              writeln(' File System Type               : ', FATtype );
            end;

        end;
    end;
  GetEnter;
end.



