/* DelTmplt.cmd - A REXX script that utilizes DMrxWPS and RexxUtil   */
/*                to delete templates from the Templates folder.     */

/* Add RexxUtil functions */
rc = rxFuncAdd( 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs');
rc = SysLoadFuncs();

/* Add DMrxWPS functions */
rc = rxFuncAdd( 'WpsLoadFuncs', 'DMrxWPS', 'WpsLoadFuncs');
rc = WpsLoadFuncs(); say rc;

/* Parse template name */
parse arg '"' TemplateName '"';
if TemplateName == '' then parse arg TemplateName;

/* If no arg name given */
if TemplateName == '' then
  do
    /* Display usage */
    say 'Usage: DelTmplt <template name>';
    exit;
  end;

/* Get path to template folder */
hTemplateFolder = WpsQueryObject( '<WP_TEMPS>');
rc = WpsQueryObjectPath( hTemplateFolder, TemplatePath);
if rc == 0 then
  do
    say 'Error getting path to Tempaltes folder.';
    exit;
  end;

/* Build fully qualified template pathname */
Template = TemplatePath || '\' || TemplateName;

/* Get handle of template */
hTemplate = WpsQueryObject( Template);

/* If hTemplate is 0x00000000, maybe it's an abstract template */
if hTemplate == '0x00000000' then
  do
    say 'Unable to delete template ''' || TemplateName || '''.';
    say 'The template may not exist or may be abstract.'
    exit;
  end;

/* Delete template */
rc = SysDestroyObject( Template);

/* Check result */
if rc == 0 then
  do
    say 'Error deleting template ''' || TemplateName || '''.';
    exit;
  end;
else
  do
    say 'Template' TemplateName 'deleted.';
  end;

exit;
