/*
 *	GENERAL.H
 *
 *	Version 1.0.0
 *
 *	Abstract:
 *	 This module contains all the definitions used by all WADLIB source files.
 *
 *	History:
 *	 1.0.0	(March 31, 1994)
 *
 *  Author:
 *	 Michael McMahon
 *
 ****************************************************************************
 *
 *  WADLIB SOFTWARE LICENSE AGREEMENT
 *
 *	1. GRANT OF LICENSE. Michael McMahon and his affiliations (collectively
 *	   the "AUTHOR") grant you (either an individual or an entity) the
 *	   non-exclusive, royalty-free right to use this library source code,
 *	   documentation, and sample code (collectively, the "SOFTWARE") for
 *	   any lawful purpose subject to the terms of this license.  By using the
 *	   SOFTWARE you are agreeing to be bound to all the terms of this license.
 *
 *	2. COPYRIGHT.  The SOFTWARE is Copyright (c) 1994, Michael McMahon,
 *	   PO Box 14807, San Luis Nabisco, CA 93406-4807 USA. All Rights Reserved
 *	   Worldwide.  You may not use, modify, or distribute the SOFTWARE except
 *	   as otherwise provided herein.
 *
 *	2. DECLARATION OF PUBLIC DOMAIN DISTRIBUTION AND USE. The distribution
 *	   and use of the SOFTWARE is hereby designated PUBLIC DOMAIN by the
 *	   the AUTHOR.	You may not sell, rent, or lease this SOFTWARE.  The
 *	   SOFTWARE may be reproduced verbatim in part or in full by any
 *	   reproduction means for any lawful purpose, and may also be subject to
 *	   the following agreement.
 *
 *	3. AGREEMENT FOR USE OF SOFTWARE. The AUTHOR grants you a non-exclusive,
 *	   royalty-free right to incorporate the SOFTWARE into any production for
 *	   any legal purpose as long as you agree
 *		(a) to indemnify, hold harmless, and defend the AUTHOR from and against
 *			any claims or lawsuits, including attorneys' fees, that arise or
 *			result from the use or distribution of your software production; and
 *		(b) no matter how much the SOFTWARE is modified, the AUTHOR owns the
 *			copyright and this original, unmodified copyright notice remains
 *			intact in the source code; and,
 *		(c) the AUTHOR is not held responsible for fixing bugs or making
 *			enhancements or changes to the SOFTWARE for any reason; and,
 *		(d) the SOFTWARE is not redistributed if it is modified in any way; and,
 *      (e) otherwise comply with the terms of this agreement; and,
 *		(f) the AUTHOR is forgiven for making so many demands.
 *
 *	 THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. THE
 *	 AUTHOR FURTHER DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING WITHOUT
 *	 LIMITATION ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR OF FITNESS
 *	 FOR A PARTICULAR PURPOSE.	THE ENTIRE RISK ARISING OUT OF THE USE
 *	 OR PERFORMANCE OF THE SOFTWARE REMAINS WITH YOU.
 *
 *	 The author can be reached at:
 *	  Michael McMahon
 *	  P.O. Box 14807
 *	  San Luis Nabisco, CA 93406-4807 USA
 *	  Internet: mmcmahon@oboe.calpoly.edu
 *	  [Bug reports, suggestions, success stories, etc. are welcome; tech
 *	   support, and other unnecessary two-way mail, is not]
 */

#ifndef GENERAL_DEFS
#define GENERAL_DEFS

/* Some general defines */
#define FALSE   0
#define TRUE    1

/* Some fields need to 16 bits; others 32 bits. If this code is being compiled
   on a 32-bit compiler, define _32_bits and compile. These definitions are
   checked with assert statements before use in every module that uses them. */
#ifdef _32_bits
typedef short int16;
typedef unsigned short uint16;
/* 256 megs/allocation max -- increase if not sufficient */
#define MALLOC_MAX	0x10000000
#else
typedef int int16;
typedef unsigned uint16;
#define MALLOC_MAX	64000L
#endif
typedef long   int32;
typedef unsigned long uint32;

/* For DOS 16 bit platforms */
#ifndef _32_bits
#define malloc(x) _fmalloc(x)
#define free(x)   _ffree(x)
#define memcpy(x,y,z) _fmemcpy(x,y,z)
#endif

#endif
