@ECHO OFF
REM Check if this program has been run before...
IF NOT EXIST DOOMWAD.OLD GOTO FreshStart
CLS
ECHO  You have run this before so I will tidy up, if you wish, after you
ECHO  have pressed a key.
ECHO  .
PAUSE
DEL DOOM.WAD
DEL THINGS.11
DEL NEW.11
RENAME DOOMWAD.OLD DOOM.WAD
:FreshStart
REM Check if doom is in directory
IF NOT EXIST DOOM.WAD GOTO :NoWadFile
GOTO WadFileExists
:NoWadFile
ECHO  Cannot Find DOOM.WAD
ECHO  You need to have all this stuff in the Registered doom directory.
GOTO Done
:WadFileExists
CLS
ECHO  Welcome to the DOOM EDITING UTILITIES
ECHO  .
ECHO  This is a batch file that guides you through the process of
ECHO  editing the doom levels.
ECHO  .
ECHO  For this demonstration you get to edit Episode 1 Map 1
ECHO  .
ECHO  This first step is to rename the old version of the DOOM.WAD File 
ECHO  (A Wad file is the file that DOOM stores all its information in)
ECHO  To rename the file we use the RENAME command from DOS.
ECHO  ie          RENAME DOOM.WAD DOOMWAD.OLD
ECHO  .
ECHO  We will rename the file now after you have pressed any key...
ECHO  (To quit press Control-C or Control-Break and answer Y)
ECHO  .
PAUSE
RENAME DOOM.WAD DOOMWAD.OLD
CLS
ECHO  Now we use the DDIR program to extract the information about the 
ECHO  things in a level to a special text file for the editor. This special
ECHO  file (called a THING DATA file) is a text file describing all the 
ECHO  things in the level.
ECHO  .
ECHO  Why do we do this?   (a pause for reflection)
ECHO  .
PAUSE
ECHO  .
ECHO  Simple. WAD files are huge. If you made changes directly to the WAD 
ECHO  file and you wanted to share them, you would have to give out a huge 
ECHO  file to your friends. Instead now you just give out this tiny little
ECHO  Thing Data File instead.
ECHO  .
ECHO  To extract the things from a WAD file to the THING DATA file you would
ECHO  use the following command:
ECHO    DDIR  DOOMWAD.OLD  EXTRACT_THINGS  1  1  Things.11
ECHO      ^       ^             ^          ^  ^     ^
ECHO      !       !             !          !  !     !
ECHO      !       !             !          !  !     +- Name for THING DATA file 
ECHO      !       !             !          !  +------- Level of Episode
ECHO      !       !             !          +---------- Episode
ECHO      !       !             +--------------------- Command for manager
ECHO      !       +----------------------------------- Original WAD File   
ECHO      +------------------------------------------- WAD file manager
ECHO  .
ECHO  We will do this command after you have pressed a key
PAUSE
DDIR DOOMWAD.OLD EXTRACT_THINGS 1 1 Things.11
PAUSE
IF EXIST THINGS.11 GOTO StepThree
ECHO  Oh dear, failed!!!
GOTO Done
:StepThree
CLS
ECHO  Now we use the graphical editor DEDT to edit the things. To do this
ECHO  we run the command:
ECHO    DEDT  DOOMWAD.OLD  1  1  Things.11  New.11
ECHO      ^       ^        ^  ^      ^        ^
ECHO      !       !        !  !      !        !
ECHO      !       !        !  !      !        +-- Things Data File Created (output)
ECHO      !       !        !  !      +----------- Original Things Data File
ECHO      !       !        !  +------------------ Level of Episode
ECHO      !       !        +--------------------- Episode
ECHO      !       +------------------------------ Original WAD file
ECHO      +-------------------------------------- The editor  (Hi Mom!)
ECHO  .
ECHO  After you press any key the editor will start. The keys are displayed
ECHO  in the bottom left corner, messages at the top.  
ECHO        Move about with Cursor keys
ECHO        Press Insert to add an object.    (T to change type)
ECHO        Press Delete to delete n object.  
ECHO        Press E when done.
ECHO  (Make sure you do actually make a change)
PAUSE
DEDT DOOMWAD.OLD 1 1 Things.11 New.11
PAUSE
IF EXIST New.11 GOTO StepFour
ECHO  Oh dear, failed!!!
ECHO  Chances are you either made no changes or pressed Q to quit 
ECHO  without saving
GOTO Done
:StepFour
ECHO  Okay now that you have edited the file we have to rebuild a new WAD
ECHO  file containing the differences. If you wanted to give this level to
ECHO  others then you would need to just give out the DDIR.EXE file and the 
ECHO  NEW.11 file to the others.
ECHO  .
PAUSE
ECHO  To rebuild a WAD file from the THING DATA file you would use the 
ECHO  following command:
ECHO    DDIR  DOOMWAD.OLD  INCLUDE_THINGS  1  1  New.11  DOOM.WAD
ECHO      ^       ^             ^          ^  ^     ^         ^
ECHO      !       !             !          !  !     !         !
ECHO      !       !             !          !  !     !  The New Wade File
ECHO      !       !             !          !  !     +- Altered THING DATA file 
ECHO      !       !             !          !  +------- Level of Episode
ECHO      !       !             !          +---------- Episode
ECHO      !       !             +--------------------- Command for manager
ECHO      !       +----------------------------------- Original WAD File   
ECHO      +------------------------------------------- WAD file manager
ECHO  .
ECHO  Press a key and the command will be run (it will take a while as
ECHO  the WAD file is over 10000K in size!)
PAUSE
ECHO  .
DDIR DOOMWAD.OLD INCLUDE_THINGS 1 1 New.11 DOOM.WAD
PAUSE
IF EXIST DOOM.WAD GOTO StepFive
ECHO  Oh dear, failed!!!
GOTO Done
:StepFive
CLS
ECHO  Now play the altered level!
ECHO  .
ECHO  To return Doom to its original state do the following commands:
ECHO    DEL  DOOM.WAD                      (deletes the altered WAD file)
ECHO    RENAME DOOMWAD.OLD DOOM.WAD        (restores original WAD file)
:Done
