/* DLG_DIZ v.01 -  1994 Marcus Johnson FlatScan Software*/

IF ~SHOW(L,'rexxsupport.library') THEN
   CALL ADDLIB('rexxsupport.library',0,-30,0)

PARSE ARG User','File

OPTIONS FAILAT 21
OPTIONS RESULTS
SIGNAL ON BREAK_C
SIGNAL ON FAILURE
SIGNAL ON SYNTAX
ADDRESS COMMAND

User2=TRANSLATE(User,' ','_')

CALL GetPort

SAY 'Searching For FILE_ID.DIZ...'
SAY

FileName = RIGHT(File,LENGTH(File)-LASTPOS('/',File))
Suffix   = UPPER(RIGHT(FileName,3))

SELECT
   WHEN Suffix = 'LHA' THEN 
        'c:LhA v >T:DIZ_Check 'File
   WHEN Suffix = 'LZH' THEN 
        'c:LhA v >T:DIZ_Check 'File
   WHEN Suffix = 'DMS' THEN 
        'c:DMSDescript x RAM:Temp.DIZ >NIL: 'File
   OTHERWISE DO
      SAY 'No FILE_ID.DIZ Found.'  
      SIGNAL FINISH
   END
END

IF Suffix = 'DMS' THEN SIGNAL DMSStuff


CALL OPEN('1','T:DIZ_Check','R')
DO WHILE ~EOF('1')
  Test = READLN('1')
  IF UPPER(RIGHT(Test,11)) = 'FILE_ID.DIZ' THEN SIGNAL MakeFILEID
END
SAY 'No FILE_ID.DIZ Found.'
SIGNAL DONE

DMSStuff:
  IF ~EXISTS('RAM:Temp.DIZ') THEN DO
    SAY 'No FILE_ID.DIZ Found.'
    SIGNAL DONE
  END
  SAY 'Found FILE_ID.DIZ !!!'
  'copy >NIL: RAM:Temp.DIZ T:'||Port.x||'.body' 
  'delete >NIL: RAM:Temp.DIZ' 
  SIGNAL DONE

MakeFILEID:
  SAY 'Found FILE_ID.DIZ !!!' 
  y=length(test)
  Path = RIGHT(Test,y-43)
  'c:Lha e >NIL: '||File' '||Path
  Path2='File:TempUploads/'||User||'/FILE_ID.DIZ'
  'copy >NIL: 'Path||' T:'||Port.x||'.body'
  'delete >NIL: 'Path
  SIGNAL DONE

GetPort:
  GotIt=0
  CALL ReadPorts
  DO WHILE x~=0
    IF EXISTS('T:'||Port.x||'.user') THEN CALL CheckForUser
    IF GotIt=1 THEN RETURN
    x=x-1
  END
  RETURN

CheckForUser:
  CALL OPEN('2','T:'||Port.x||'.user','R')
  WhatUser = READCH('2',LENGTH(User))
  IF User2=WhatUser THEN GotIt=1
  Port=Port.x
  CALL CLOSE('2')
  RETURN

ReadPorts:
  CALL OPEN('3','DOORS:DLG_DIZ/Ports_DIZ','R')
  x=1
  DO WHILE ~EOF('3')
    Port.x=READLN('3')
    x=x+1
  END
  CALL CLOSE('3')
  RETURN 

BREAK_C:
FAILURE:
SYNTAX:
  SAY 
  SAY '*DLG_DIZ Has An Error!!!!!!.     *'
  SAY '*Please Inform Your Sysop.       *'
  SAY '*Line:' SIGL '   Error Code:' RC'*'
  SAY
  EXIT
DONE:
  CALL CLOSE('1')
  'delete >NIL: T:DIZ_Check'
FINISH:
  SAY
  EXIT
