/***************************************************************************

  copyright 1990-93 by TelePro Technologies
   All rights reserved
 
The material within is the sole property of TelePro Technologies.  It may
not be distributed outside of this archive, in whole or in part, without
express written permission from TelePro Technologies.

*****************************************************************************/


#include <exec/types.h>
#include <exec/io.h>
#include <libraries/dos.h>
#include <libraries/dosextens.h>

#define CRONCONTROL "TPTCRON"

/* CronMessage types */

#define ADDEVENT	1	/* Add an event */
#define DELEVENT	2	/* Delete an event */
#define LISTEVENTS	3	/* List dynamic events */
#define CRONEXIT	4	/* Shut down TPTCron */
#define WHENEVENT	5	/* Check the next occurrence of an event */
#define READFILE	6	/* Read a new CronTab file */
#define TABLIST		7	/* List CronTab events */
#define CHANGEDIR	8	/* Change TPTCron's working directory */

/* Errors returned in the type field *
 * If the type was DELEVENT, it will *
 * return the number of events that  *
 * actually were deleted.	     */

#define CNOERR		0	/* No error */
#define OUTOFMEM	-1	/* Out of memory error */
#define BADSYNTAX	-2	/* Bad message type */
#define NOCRON		-3	/* TPTCron not active */
#define TABNOTFOUND	-4	/* CronTab not found */
#define NOEVENTS	-5	/* No events to list */
#define DIRNOTFOUND	-6	/* New directory not found */


/* Structure of CronTab events */

struct CronEntry
{
  char *min, *hour, *day, *month, *wday, *command;
};


/* Message structure to issue a command to TPTCron */

struct CronMessage
{
  struct Message mess;		/* Exec Message structure */
  char type;			/* Message type */
  ULONG minutes;		/* Minutes until event */
  char *command;		/* Event to add/delete/search for, or
				   new CronTab file or directory */
  struct FileHandle *ofh;	/* AmigaDOS FileHandle to send output to */
};


/* Structure of dynamic events */

struct EventNode
{
  ULONG time;			/* Time event is to be executed */
  char *command;		/* Command to be executed */
  struct EventNode *nextevent;	/* Pointer to next event in list */
};
