#if !defined(__interface_h)
#define __interface_h
#include<graphics.h>
#include "mouse.h"

enum THINGS {BUTTON, FIELD, SLIDE, RADIO,CHECKBOX,PIC};
enum INPUT_TYPE {KEYBOARD, MOUSE,NOTHING};
enum FIELDTYPE {NUMBER, TEXT};
enum BUTTON_STATUS {UNPRESSED, PRESSED};
enum CHECKBOX_STATUS {UNCHECKED, CHECKED};

const int DELAYTIME=200;   //milliseconds in delay of button press
const int MAXSTRINGLEN=127;
const int MAXLINES=50;
const int MAXLBOXES=50;
const int MAXBUTTONS=30;
const int MAXPICS_S=50;
const int MAXPICS=50;
const int MAXCHECKBOXES=20;
const int MAXFIELDS=10;
const int MAXSLIDES=20;
const int MAXTITLES=30;
const int MAXBARS=1;
const int MAXBOXES=1;
const int MAXRADIOS=10;
const int HEIGHT=20;       //height of buttons
const int FIELDHEIGHT=15;

typedef struct i_face { THINGS type;
			int code; //used to ID the corresponding thing
				  //better be unique
			char * return_text;
			int return_value;
			BUTTON_STATUS button_status;
			CHECKBOX_STATUS checkbox_status;
			struct i_face * next;} return_type;

typedef struct {int finished;
		INPUT_TYPE transfer;} control_struct;

typedef struct _zones { int x1,y1,x2,y2; //coordinates of box
		       THINGS type;
		       int number;
		       struct _zones * next;} zone_type;

typedef struct { int x,y;
		 char k1,k2;
		 INPUT_TYPE type;
	       } input_struct;

typedef struct {char * text;
		int x;int y;
		int code; int width;
		int x1;int y1;int x2;int y2;
		return_type * return_code;
		} button_struct;

typedef struct {
		  int x;int y;
		  int width,height;
		  int code;
		  void far *pic;
		  return_type * return_code;
		} pic_struct;

typedef struct {
		  int x;int y;
		  void far *pic;
		} pic_s_struct;

typedef struct {char * text;
		int x;int y;
		int code;
		return_type * return_code;
		} checkbox_struct;

typedef struct {char * deftext;
		int x; int y;
		int width; int code;
		return_type * return_code;
		char ret[MAXSTRINGLEN+1];
		FIELDTYPE ftype;
		} field_struct;

typedef struct {int defvalue;
		int x; int y;
		int code;
		return_type * return_code;
		} slide_struct;

typedef struct {char * text;
		int x; int y;
		int color;
		int size; int font;
		int horiz_just;int vert_just;
		} title_struct;

typedef struct {char * text;
		int x;int y;
		int code;
		int radio_id;
		return_type * return_code;
		} radio_struct;

typedef struct {int x; int y;
		int width; int height;
		int color; int border;
		void far *buf;
		} box_struct;

typedef struct {int x1; int y1;
		int x2; int y2;
		int color;
		} line_struct;

typedef struct {int x1; int y1;
		int x2; int y2;
		int color;
		} lbox_struct;

typedef struct {char *s;
		int color;
		int font;
		int font_size;
		int font_color;
		int height;
		} bar_struct;

typedef struct {pic_struct pics[MAXPICS];
		pic_s_struct pics_s[MAXPICS_S];
		line_struct lines[MAXLINES];
		lbox_struct lboxes[MAXLBOXES];
		button_struct buttons[MAXBUTTONS];
		field_struct fields[MAXFIELDS];
		slide_struct slides[MAXSLIDES];
		title_struct titles[MAXTITLES];
		box_struct boxes[MAXBOXES];
		bar_struct bars[MAXBARS];
		checkbox_struct checkboxes[MAXCHECKBOXES];
		radio_struct radios[MAXRADIOS];
		int numpics, numbuttons, numfields, numslides, numtitles,
		  numboxes, numradios,numcheckboxes, numbars, numlines,
		  numlboxes, numpics_s;
		int dont_erase;
		int mouse_placed;
		int mouse_locked;
		int mouse_x,mouse_y;
		control_struct control;
		int charwidth;
		int boxx,boxy;
		return_type * return_head;
		zone_type * zones;
		zone_type * zones_head;
		zone_type * curzone;

		int disk_writes;
		char file_name[128];
		} interface_struct;

class interface_class {
    interface_struct interface;
    int slideheight,slidewidth;
    void error(char *);
    void operate_items();
    zone_type * find_new_zone();
    void setup_mouse_zone(int, int, int, int,
			  THINGS ,int);
    int  inzone(int, int, zone_type*);
    return_type * add_setup_return();
    return_type * setup_return(int, int);
    return_type * setup_return(int, char*,
			       char*, FIELDTYPE);
    return_type * setup_return(int, BUTTON_STATUS);
    return_type * setup_return(int, CHECKBOX_STATUS);
    void dopic(int);
    void docheckbox(int);
    void doradio(int);
    void dobutton(int);
    void doslide(int);
    void dofield(int);
    void highlight_slide(int);
    void highlight_slide_left(int);
    void highlight_slide_right(int);
    void update_slide(int);
    void highlight_radio(int);
    void unhighlight_radio(int);
    void uncheck_others(int,int);
    void clear_radio(int);
    void check_radio(int);
    void toggle_radio(int);
    void highlight_checkbox(int);
    void unhighlight_checkbox(int);
    void clear_checkbox(int);
    void check_checkbox(int);
    void toggle_checkbox(int);
    void highlight_pic(int);
    void unhighlight_pic(int);
    void highlight_button(int);
    void unhighlight_button(int);
    void do_save_image(int,int,int,int);
    void lock_mouse();
    void press_pic(int);
    void press_button(int);
    void draw_pics();
    void draw_pics_s();
    void draw_buttons();
    void draw_checkboxes();
    void draw_bars();
    void draw_lboxes();
    void draw_lines();
    void draw_boxes();
    void draw_radios();
    void erase_boxes();
    void draw_titles();
    void draw_slides();
    void draw_items();
    void erase_items();
    void reset_input();
    void getinput(input_struct*);
    void draw_fields();
    void draw_cursor(int);
    void hide_cursor(int);
    void highlight_field(int);
    void unhighlight_field(int);
    void update_field(int);
    void free_zone_list();
    void free_return_list();
    return_type * find_item(int);
  public:
    mouse_class mouse;
    interface_class();
    void disk_writes_on(char *);
    void lock_mouse_in_box();
    void place_mouse(int,int);
    void set_dont_erase();
    void clear();
    void set_mouse_bounds(int,int,int,int);
    void addline(int,int,int,int,int);
    void addlbox(int,int,int,int,int);
    void addbar(char*,int color=BLUE,int font=DEFAULT_FONT,int font_size=1,int font_color=15);
    void addcheckbox(char*,int, int, int,CHECKBOX_STATUS);
    void addradio(char*,int, int, int,int,CHECKBOX_STATUS);
    void addpic_b(int x, int y, int width, int height, int code,void far *p);
    void addpic_s(int x, int y, void far *p);
    void addbutton(char*,int, int, int, int width=60);
    void addfield(char*, int, int, int, int,
		   FIELDTYPE);
    void addslide(int, int, int, int);
    void addtitle(char *, int, int, int color=DARKGRAY,
		  int size=1, int font=DEFAULT_FONT,int horiz_just=LEFT_TEXT,
		  int vert_just=TOP_TEXT);
    void addbox(int, int, int, int,
		int color=WHITE, int border=LIGHTGRAY);
    void dodialog();
    
    CHECKBOX_STATUS get_checkbox_info(int);
    CHECKBOX_STATUS get_radio_info(int);
    BUTTON_STATUS get_button_info(int);
    BUTTON_STATUS get_pic_info(int);
    char * get_text_field_info(int);
    int get_number_field_info(int);
    int get_slide_info(int);
    };
#endif
