program DLBTest;

{
Sample application using the "divided listbox custom control"
from DIVLSTBX.PAS.
}
{Copyright  1994 Andrew J Wozniewicz}
  {
  I am hereby making this program available, but retain the copyright to same.
  You are free to use this code in any way you like, except for publishing in whole
  or portions thereof in a source code format.

  This source code is provided AS IS. Please use it at your own risk.
  The author gives no warranty, express or implied, as to suitability of this
  code or the processes it describes for any particular purpose. The author
  assumes no liability whatsoever for any damages that may result, either directly
  or indirectly, from the use of this source code, or any derivatives thereof,
  including compiled object code.

  Please, let me know if you find any bugs or a way to improve it.

  Enjoy,

  Andrew J. Wozniewicz
  CompuServe: 75020,3617
  July 14, 1994
  }

uses
  WinTypes,
  WinProcs,
  WColor,
  Strings,
  DivLstBx,
  OWindows;

const
  id_lbItems = 101;


type

  PCustomDataListBox = ^TCustomDataListBox;
  TCustomDataListBox = object(TDataListBox)
    procedure PaintHeader(DC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure DrawItem(wParam: Word; lParam: LongInt);
    procedure FieldFromItemRect(var aRect: TRect; field: Integer);
  end;


  PMainWindow = ^TMainWindow;
  TMainWindow = object(TWindow)
  private
    lst: PCustomDataListBox;
  public
    constructor Init;
    procedure SetupWindow; virtual;
    procedure WMSize(var msg: TMessage); virtual wm_First + wm_Size;
    procedure WMDrawItem(var msg: TMessage); virtual wm_First + wm_DrawItem;
  end;


  PThisApp = ^TThisApp;
  TThisApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;


{TCustomDataListBox}

  procedure TCustomDataListBox.PaintHeader;
  var
    wRect: TRect;
    off: Integer;
    oldPen: HPen;
    DrawStruct: TDrawItemStruct;
    splitPos: Integer;
    n: Integer;
    buf: array[0..31] of Char;

  procedure PaintSplitter(p: Pointer); far;
    begin
      SplitPos := Integer(LongInt(p)) + off;
      MoveTo(DC,SplitPos-HScrollPos,0);
      LineTo(DC,SplitPos-HScrollPos,myItemHt);
    end;


  procedure PaintLabel(p: Pointer); far;
    begin
      n := Splitters^.IndexOf(p)+1;
      WVSprintf(buf,'Header %i ',n);
      SplitPos := Integer(LongInt(p)) + off - HScrollPos;
      wRect.right := SplitPos;
      ExtTextOut(DC,wRect.left+3,wRect.top,ETO_CLIPPED,@wRect,buf,StrLen(buf),nil);
      {pseudo-bold effect}
      ExtTextOut(DC,wRect.left+4,wRect.top,ETO_CLIPPED,@wRect,buf,StrLen(buf),nil);
      wRect.left := wRect.right;
    end;


  begin
    GetWindowRect(HWindow,wRect);
    {Paint Gray Headers}
    with PaintInfo do begin
      wRect.left := 0;
      wRect.top := rcPaint.top;
      wRect.bottom := rcPaint.bottom;
      FillRect(DC,wRect,GetStockObject(LTGRAY_BRUSH));
      MoveTo(DC,rcPaint.left,rcPaint.bottom);
      LineTo(DC,rcPaint.right,rcPaint.bottom);
      off := 1;
      Splitters^.ForEach(@PaintSplitter);
      off := 2;
      oldPen := SelectObject(DC,GetStockObject(WHITE_PEN));
      Splitters^.ForEach(@PaintSplitter);

      SetBkMode(DC,Transparent);
      SetRect(wRect,3,wRect.top,3,wRect.bottom);
      SplitPos := 3;
      Splitters^.ForEach(@PaintLabel);

      n := Splitters^.Count+1;
      WVSprintf(buf,'Header %i',n);
      wRect.right := attr.w;
      ExtTextOut(DC,wRect.left+3,wRect.top,ETO_CLIPPED,@wRect,buf,StrLen(buf),nil);
      {pseudo-bold effect}
      ExtTextOut(DC,wRect.left+4,wRect.top,ETO_CLIPPED,@wRect,buf,StrLen(buf),nil);

      SelectObject(DC,oldPen);
    end;
  end;


  procedure TCustomDataListBox.DrawItem;
    var
      info: PDrawItemStruct absolute lParam;
      buf: array[0..63] of Char;
      iRect: TRect;
      field: Integer;
      XY: TPoint;
    begin with info^ do begin
      for field := 0 to Splitters^.Count do begin
        XY.X := field+1;
        XY.Y := ItemID+1;
        WVSprintf(buf,'Item %i,%i',XY);
        iRect := rcItem;
        FieldFromItemRect(iRect,field);
        if (itemState and ODS_SELECTED) <> 0 then begin
          SetTextColor(hDC,GetSysColor(color_HighlightText));
          SetBkColor(hDC,GetSysColor(color_Highlight));
        end else begin
          SetTextColor(hDC,GetSysColor(color_WindowText));
          SetBkColor(hDC,GetSysColor(color_Window));
        end;
        ExtTextOut(hDC,iRect.left+4,iRect.top,ETO_CLIPPED or ETO_OPAQUE,@iRect,buf,StrLen(buf),nil);
      end;
    end; end;


  procedure TCustomDataListBox.FieldFromItemRect;
    begin
      if Splitters^.Count = 0 then
        Exit;
      if field > 0 then begin
        aRect.Left := Integer(LoWord(LongInt(Splitters^.At(field-1))));
        Inc(aRect.left,1);
      end;
      if field < Splitters^.Count then begin
        aRect.right := Integer(LoWord(LongInt(Splitters^.At(field))));
        Dec(aRect.right,HScrollPos);
      end;
      Dec(aRect.left,HScrollPos);
    end;




{TMainWindow}

  constructor TMainWindow.Init;
    begin
      inherited Init(nil,'Divided List Box w/Headers Example');
      New(lst,Init(@self,id_lbItems,0,0,1,1));
      lst^.attr.style := lst^.attr.style or LBS_NOINTEGRALHEIGHT;
      lst^.AddSplitter(80);
      lst^.AddSplitter(150);
      lst^.AddSplitter(250);
      lst^.AddSplitter(650);
      lst^.AddSplitter(950);
      lst^.AddSplitter(1200);
    end;


  procedure TMainWindow.SetupWindow;
    var
      i: Integer;
    begin
      inherited SetupWindow;
      for i := 0 to 100 do begin
        lst^.AddString(nil);
      end;
      SendMessage(lst^.HWindow,LB_SETHORIZONTALEXTENT,1200,0);
    end;


  procedure TMainWindow.WMSize;
    begin
      inherited WMSize(msg);
      MoveWindow(lst^.HWindow,0,0,LoWord(msg.lParam),HiWord(msg.lParam),True);
    end;


  procedure TMainWindow.WMDrawItem;
    begin
      lst^.DrawItem(msg.wParam,msg.lParam);
      msg.result := 1;
    end;



{TThisApp}

  procedure TThisApp.InitMainWindow;
    begin
      MainWindow := New(PMainWindow,Init);
    end;


var
  a: TThisApp;
begin
  a.Init(nil);
  a.Run;
  a.Done;
end.
