unit TDivide;

{Provided by John Newlin [71535,665] for use by anyone doing
 anything with Delphi.  Donated to the public domain.  If you
 find this tool useful, dropping me a thank you via CIS email
 would be appropriate.

 This is a simple extension of the Tbevel component that is
 designed to make the use of a bevel as a horizontal or
 vertical line much easier.  Yes, I know that the same effect
 can be accomplished by setting the align and shape properties
 but the resulting design rectangle tends to clutter the
 client area, expecially if you have a lot of them.}

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Controls,
  Forms, Graphics, StdCtrls, ExtCtrls;

Type
  OrientType = (oNone,oHoriz,oVert);
  TDivider = Class(Tbevel)
    private
      FOrient:OrientType;
    protected
      procedure SetOrient(value:OrientType);
      procedure Paint; override;
    published
      property Orientation:OrientType read FOrient write SetOrient default oHoriz;
  End;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Utility',[TDivider]);
end;

procedure TDivider.SetOrient(value:OrientType);
begin
  if value <> fOrient then
    begin
      FOrient := value;
      {keep it from snapping full left or full top so we
       can find it after setting}
      case FOrient of
        oHoriz : top := 20;
        oVert : left := 20;
      End; {of case}
      invalidate;
    end;
end;

procedure TDivider.Paint;
begin
  if FOrient in [oHoriz,oVert] then
    case FOrient of
      oHoriz :
        begin
          Shape := bsTopLine;
          Height := 2;
          Left := Parent.left + ((Parent.Width - Parent.ClientWidth) div 2);
          Width := Parent.ClientWidth;
        end;
      oVert :
        begin
          Shape := bsLeftLine;
          Width := 2;
          Top := ((Parent.Height - Parent.ClientHeight) div 2);
          Height := Parent.ClientHeight;
        end;
    End; {of case}
  inherited paint;
end;

END.
