#include <stdlib.h>
#include <stdio.h>

#include DRIVER

GrDriverHeader driver_header;

void dump_modeinfo(GrModeEntry *md)
{
	char setup[40];

	printf(
	    "  Width=%-4d  Height=%-4d  Colors=%-8ld  BIOS mode=0x%03x  Setup=%s\n",
	    md->width,
	    md->height,
	    md->number_of_colors <= 32768U ?
		(long)md->number_of_colors :
		(1L << (md->number_of_colors & 0x0ff)),
	    md->mode.vdr.BIOS_mode,
	    md->mode.vdr.custom_setup_index == 0 ?
		"STANDARD" :
		(sprintf(setup,"%d",md->mode.vdr.custom_setup_index), setup)
	);
}

void main(void)
{
	printf(driver_name);
	if(driver_init_routine()) {
	    GrModeEntry *tx = text_mode_table;
	    GrModeEntry *gr = graphics_mode_table;
	    printf("\ntext modes:\n");
	    while(tx->width > 0) {
		dump_modeinfo(tx);
		tx++;
	    }
	    printf("\ngraphics modes:\n");
	    while(gr->width > 0) {
		dump_modeinfo(gr);
		gr++;
	    }
	}
	else printf("\ndriver initialization routine failed\n");
	exit(0);
}

