Function NWStoD
* NetWare String to date function

Parameter cString
private y, m, d, cDate, cAnswer
if empty(cString)
	return {}
endif
y=left(cString,4)
d=right(cString,2)
m=substr(cString,5,2)
cDate=set('DATE')
do case
case cDate='MDY' .or. cDate='AMERICAN'
	cAnswer=M+'/'+d+'/'+Y
case cDate='ANSI'
	cAnswer=Y+'.'+m+'.'+d
case cDate="BRITISH" .or. cDate="FRENCH" .or. cDate='DMY'
	cAnswer=d+'/'+M+'/'+y
case cDate='GERMAN'
	cAnswer=d+'.'+m+'.'+y
case cDate='ITALIAN'
	cAnswer=d+'-'+m+'-'+y
case cDate='JAPAN' .or. cAnswer='YMD'
	cAnswer=y+'/'+m+'/'+d
case cDate='USA'
	cAnswer=m+'-'+d+'-'+y
otherwise
	msgbox('Unknown date formatting.  Check function '+;
		'NWStoD() and modify if necessary for local date type')
endcase
return ctod(cAnswer)
