@ECHO OFF
rem bat file to use dg with wildcarded list-of-files-to-search
rem usage dgw -dg_arguments searchterm [*.txt or ad.* etc.] 
rem note: a dg argument must be given, at least -o (a do-nothing)
rem note: always writes result to file named ztempx (and sends to more)
rem note: thus ztempx must not be in the scope of the wildcard

IF "%1" == "" GOTO helps
IF "%3" == "" GOTO error
ECHO ======Executing the command dg %1 %2 %3 %4 %5 %6
ECHO ======Will overwrite ztempx
ECHO ======RETURN to continue, ctrl-C to quit
PAUSE
IF EXIST ztempx  DEL ztempx>NUL
rem if touch program not available, use: @REM redirect_to ztempx
rem touch ztempx
@REM >ztempx

rem current setup for 6 total args: supports, e.g., up to -m3
rem its possible to send 11 arguments with, e.g., -m9
rem expand below to handle 11 if desired
if exist %6 goto six
if exist %5 goto five
if exist %4 goto four
if exist %3 goto three

:six
FOR %%X IN (%6) do if %%X==ZTEMPX goto scope
FOR %%X IN (%6) DO COMMAND/C dg %1 %2 %3 %4 %5 %%X >> ztempx
goto didsearch
:five
FOR %%X IN (%5) do if %%X==ZTEMPX goto scope
FOR %%X IN (%5) DO COMMAND/C dg %1 %2 %3 %4 %%X >> ztempx
goto didsearch
:four
FOR %%X IN (%4) do if %%X==ZTEMPX goto scope
FOR %%X IN (%4) DO COMMAND/C dg %1 %2 %3 %%X >> ztempx
goto didsearch
:three
FOR %%X IN (%3) do if %%X==ZTEMPX goto scope
FOR %%X IN (%3) DO COMMAND/C dg %1 %2 %%X >> ztempx
goto didsearch

:didsearch

echo ================ FINDS: ===================================
TYPE ztempx | more
ECHO =========== Finds placed in file ztempx ===================
GOTO end
:scope
echo ERROR- the wildcard term includes the output file "ztempx"
goto paterror
:error
ECHO   dgw error.
:helps
ECHO   dgw is used to do a dg-search against a wildcard list-of-files.
ECHO   e.g. " dgw -Kp searchterm *.foo " 
ECHO   A dg argument must be used. Use -o for a do-nothing argument.
ECHO   e.g. " dgw -o  searchterm *.txt " 
:paterror
ECHO   The output of each search is written to file "ztempx"
ECHO   Be sure that the wildcard term cannot "see" the file tempx
ECHO   NAME.* or *.NAM is ok. But be in a separate directory to use * or *.*
ECHO   e.g., NOT "dgw -o  searchterm *.*" NOR "dgw -o  searchterm *"
ECHO   e.g., BUT "dgw -o  searchterm subdir/*.*" will work.
:end

