/* DXF23D2 */

#include	<conio.h>
#include        <stdlib.h>
#include        <stdio.h>
#include        <math.h>
#include        <string.h>

#define	MAXPOINTS	1000
#define	MAXFACES	1000
#define	MAXPPF		  10               // Max points per face



	FILE    *dxf_in_file,*objfile;
char	*fname;
double	x1; double	y1; double	z1; double	x2; double	y2;
double	z2; double	x3; double	y3; double	z3; double	x4;
double	y4; double	z4;

void	save_points(double scale);
void	process_points(void);
int	checkold(int trntc,double tmpx, double tmpy, double tmpz);
void	output3d3(void);

main(int argc, char *argv[])
{

	fname = argv[2];
	char    str[80];
	int     key, npnts,layer,l;
	double  scale = 1.0;
	scale = atof(argv[4]);			// scale factor
	if(scale <= 0) scale = 1;

	if(argc < 3) {
		printf("\nDXF23D3 Version 0.01 - Adapted from Stephen Coy's DXF2V\n");
		printf("Converts 3DFACEs in DXF files to 3D3 files of 3D3 object file data.\n");
		printf("Extracts by Layers (if desired)\n");
		printf("Added code by Tom Barber 4/92  Mike Daigle 7/92\n");
		printf("Modified code to output RAW triangles 7/92 Adam Shiffman\n\n");
	printf("     ͻ\n");
	printf("      Modified & added code to convert to 3D3 object data  \n");
	printf("                     3/93 Chris Olivier                    \n");
	printf("     ͼ\n");
	printf("\nUsage: dxf23d3 file.dxf file.inc <Layer Number> [Scale]\n\n");
		printf("Where:\n");
		printf("       file.dxf = name of dxf file with extension\n");
		printf("       file.inc = name of inc file with extension\n");
		printf("       <Layer #>= Layer to be converted.  Must be specified\n");
		printf("       [Scale]  = Scale factor for points (can be floating point)");
		printf("\n\n Typical: DXF23D3 obj.dxf obj.inc -1 1\n");
		printf("          (convert obj.dxf to obj.inc all layers)\n");
		exit(1);
	}

	//Open the files
	if (!(dxf_in_file = fopen(argv[1],"rb")))
		{ puts("Can not open DXF file!");
		  exit(1);
		}
layer = -1;

if (argc > 3) layer = atoi(argv[3]);

	while(fgets(str, 80, dxf_in_file)) {
		//Wait until we find a 3DFACE...
		if(strncmp(str, "3DFACE", 6) != 0) {continue;}
		   fgets(str,80,dxf_in_file);
		   if (atoi(str) != 8) {printf("WARNING...LAYER...MISSED\n");}
		   fgets(str,80,dxf_in_file);

		   if (layer != atoi(str) && layer != -1)   {continue;}

		x1 = x2 = x3 = x4 = y1 = y2 = y3 = y4 = z1 = z2 = z3 = z4 = 0.0;
		do {
			fgets(str, 80, dxf_in_file);
			key = atoi(str);
			fgets(str, 80, dxf_in_file);
			switch(key) {
				case 10 : x1 = atof(str); break;
				case 20 : y1 = atof(str); break;
				case 30 : z1 = atof(str); break;
				case 11 : x2 = atof(str); break;
				case 21 : y2 = atof(str); break;
				case 31 : z2 = atof(str); break;
				case 12 : x3 = atof(str); break;
				case 22 : y3 = atof(str); break;
				case 32 : z3 = atof(str); break;
				case 13 : x4 = atof(str); break;
				case 23 : y4 = atof(str); break;
				case 33 : z4 = atof(str); break;
				default : break;
			}
		} while(key != 33);

	save_points(scale);


//		if(npnts < 3) continue;
   }

   process_points();

fclose(objfile);
fclose(dxf_in_file);
output3d3();
printf("\nScale = %.4f",scale);
//printf("\n\nPress a key...\n");
//getch();
return	0;
}       /* end of main() */

//============================================================================
// SUB: SavePoints
//============================================================================
// Global Point Vars


int     trnct 		= 	0;
int	num_faces	=	0;
int	num_points	=	0;
int	this_face	=	0;
int	this_point	=	0;

double	xf[MAXPOINTS];
double	yf[MAXPOINTS];
double	zf[MAXPOINTS];

int	xi[MAXPOINTS];
int	yi[MAXPOINTS];
int	zi[MAXPOINTS];

int 	facelist[MAXFACES][MAXPPF];	// [face #][pointlist order]
					// repeat marks last one (pad w/ 0)
void 	save_points(double scale)

{
	int	ptsinface = 0;


	num_faces++;			// Face these points apply to
	this_face++;			// Face we're working on

	this_point++;			// current point in list (gross)
	xf[this_point]=x1*scale;
	yf[this_point]=y1*scale;
	zf[this_point]=z1*scale;
	facelist[this_face][1] = this_point;


	this_point++;			// current point in list (gross)
	xf[this_point]=x2*scale;
	yf[this_point]=y2*scale;
	zf[this_point]=z2*scale;
	facelist[this_face][2] = this_point;


	this_point++;			// current point in list (gross)
	xf[this_point]=x3*scale;
	yf[this_point]=y3*scale;
	zf[this_point]=z3*scale;
	facelist[this_face][3] = this_point;

	this_point++;			// current point in list (gross)
	xf[this_point]=x4*scale;
	yf[this_point]=y4*scale;
	zf[this_point]=z4*scale;
	facelist[this_face][4] = this_point;

	facelist[this_face][5] = facelist[this_face][1];
	facelist[this_face][6] = 0;	// padding


// Check if its a triangle


	if(x4==x3 && y4==y3 && z4==z3) {
		this_point--;
		ptsinface = 3;	       // this is a triangle
		facelist[this_face][4] = facelist[this_face][1];
		facelist[this_face][5] = 0;
	}
	else	ptsinface = 4;

// put # of points in face in position 0 of face_list

	facelist[this_face][0] = ptsinface;

	num_points = num_points+ptsinface;
}
//============================================================================
// SUB: ProcessPoints
//============================================================================

void	process_points(void) {
// double	xx = 0.0,yy = 0.0, zz=0.0;

	printf("\n\nNumber of points: %d",num_points);
	printf("\nNumber of faces : %d",num_faces);
//----------------------------------------------------------------------------
// TRUNCATE POINTS
//----------------------------------------------------------------------------

	double	tmpx,tmpy,tmpz;
	int	point_table[MAXPOINTS];
	int	ptnum = 0;
// Fill Point_table with garbage
	for (int xxxx=0;xxxx<=MAXPOINTS;xxxx++) point_table[xxxx] = 9999;
// Check for repeated points & set pointer to that point in Point_Table
	for(int nnn=1;nnn<=num_points;nnn++)
	{
		tmpx = xf[nnn];
		tmpy = yf[nnn];
		tmpz = zf[nnn];
		if((checkold(trnct,tmpx,tmpy,tmpz)) == 0)  // if not in list...
		{

			trnct++;
			xi[trnct] = (xf[nnn] + 0.5);
			yi[trnct] = (yf[nnn] + 0.5);
			zi[trnct] = (zf[nnn] + 0.5);

			point_table[nnn] = trnct;
		}
		else
		{
		ptnum = checkold(trnct,tmpx,tmpy,tmpz);
		point_table[nnn] = ptnum;
		}

	}
	printf("\n\nNumber of unique points: %d\n",trnct);
//	getch();



//	for(int j=1;j<=trnct;j++)
//	{
//		printf("\nPoint %d : ( %d, %d, %d)",j,xi[j],yi[j],zi[j]);
//	}

//	printf("\n\nPress a key...");

//	for(j=1;j<=num_points;j++)
//	{
//		printf("\nPoint %d   \t-=>\t Point %d",j,point_table[j]);
//	}

//	printf("\n\nPress a key...");
//	getch();
//----------------------------------------------------------------------------
// Now, put the face orders together
//----------------------------------------------------------------------------
	int	n = 0;
	int	k = 0;
	int 	j;
	for(j=1;j<=num_faces;j++)
	{
		k=facelist[j][0];	// Number of points for this face
		for(int m=1;m<=k+1;m++)
		{
			n = facelist[j][m];
			facelist[j][m] = point_table[n];
		}
	}
/*
	for(j=1;j<=num_faces;j++)
	{
		printf("\nFace #%d:  (",j);
		for(k=1;k<=facelist[j][0]+1;k++)
		{
			printf(" Pt%d",facelist[j][k]);
		}
		printf(" )");
	}
*/
}
//============================================================================
// SUB: Checkold(tmpx,tmpy,tmpz)
// 	Check if point is already in list
//      Returns 0 if its not already in the list
//	Returns POINT# if already in list.
//============================================================================
int	checkold(int trnct,double tmpx, double tmpy, double tmpz)
{
double	ttmpx,ttmpy,ttmpz;

	for(int nn=1;nn<=trnct;nn++)
	{
		ttmpx=xf[nn];
		ttmpy=yf[nn];
		ttmpz=zf[nn];
		if(ttmpx==tmpx && ttmpy==tmpy && ttmpz==tmpz) return nn;
	}

return 0;
}
//============================================================================
// SUB: Output3D3
//	Output 3D3 file
//============================================================================
void	output3d3(void)
{
	if (!(objfile = fopen(fname,"w")))
		{ puts("Can not open file for output!");
		  fclose(dxf_in_file);
		  exit(1);
		}
//----------------------------------------------------------------------------
// File open....Now write header
//----------------------------------------------------------------------------

//	fprintf(objfile,"%.4f %.4f %.4f\n\n", x4, y4, z4);
	fprintf(objfile,"; Object data generated by DXF23D3 v0.01 for 3DVECT35");
	fprintf(objfile,"\n\n; Number of unique points = %d",trnct);
	fprintf(objfile,"\nlabel\tdw\t%d",trnct);
	fprintf(objfile,"\n; Number of faces = %d",num_faces);
	fprintf(objfile,"\n\tdw\t%d",num_faces);
	fprintf(objfile,"\n; Furure use words");
	fprintf(objfile,"\n\tdw\t25 dup (0)\n");
	fprintf(objfile,"\ndfltcolr\tequ\t1\n");   	// default color
// Start of points loop
	fprintf(objfile,"; POINTS");
//------------------------------+
// Print out points             +
//------------------------------+

	for(int j=1;j<=trnct;j++)
	{
		fprintf(objfile,"\n\tdw\t%d, %d, %d\t\t\t; Point %d",xi[j],yi[j],zi[j],j);
	}

	fprintf(objfile,"\n\n; FACES\n");

	for(j=1;j<=num_faces;j++)
	{
// This is the header for each face...
		fprintf(objfile,"\ndw \t0,shade,0,dfltcolr,0 ");

		for(int k=1;k<=facelist[j][0]+1;k++)
		{
			fprintf(objfile,", %d",facelist[j][k]);
		}

		fprintf(objfile,"  ,0,0,0\t; Face #%d",j);

	}
// Pad the bottom (I hate not being able to cursor past EOF!
	fprintf(objfile,"\n\n\n\n");
// Done.  Close the file
	fclose(objfile);
}
//============================================================================
//============================================================================
//============================================================================
