
/******************************************************************************
*																										*
*	        DeskFont Control Panel Applet by Mark Gamber  (Sept 93)            *
*																										*
******************************************************************************/

#include "windows.h"
#include "shellapi.h"
#include "commdlg.h"
#include "cpl.h"
#include "ctl3d.h"  //  ..............................Optional, if you have it.
#include "deskfont.h"


HINSTANCE hInst;
char *TITLE = "DeskFont";
char *HELPFILE = "deskfont.hlp";
BOOL HelpLoaded;


// ---- DLL Entry Point for Windows NT ----------------------------------------

BOOL WINAPI DLLEntryPoint( HINSTANCE hInstance, DWORD dwReason, 
                           LPVOID lpvReserved )
{
	return( TRUE );
}

// ---- Control Panel Applet Entry Point --------------------------------------

LONG CALLBACK CPlApplet( HWND hWnd, UINT uMsg, LPARAM lParam1, LPARAM lParam2 )
{
   switch( uMsg )
   {
      case CPL_INIT: 
         hInst = GetModuleHandle( "deskfont.cpl" );       //  Find our instance
         return TRUE;

      case CPL_GETCOUNT: 
         return( 1 );									      //  We support one applet

      case CPL_NEWINQUIRE:				   //  Tell Control Panel about this applet
		{
			LPNEWCPLINFO lpNewCPlInfo;

         lpNewCPlInfo = (LPNEWCPLINFO)lParam2;

         lpNewCPlInfo->dwSize = (DWORD)sizeof(NEWCPLINFO);
         lpNewCPlInfo->dwFlags = 0;
         lpNewCPlInfo->dwHelpContext = 0;
         lpNewCPlInfo->lData = 0;
         lpNewCPlInfo->hIcon = LoadIcon( hInst, MAKEINTRESOURCE( 100 ) );
         lpNewCPlInfo->szHelpFile[ 0 ] = '\0';
         LoadString( hInst, 100, lpNewCPlInfo->szName, 32 );
         LoadString( hInst, 101, lpNewCPlInfo->szInfo, 64 );
         break;
		}

      case CPL_DBLCLK:                        //  If applet icon is selected...
			Ctl3dRegister( hInst );			  //  If you have CTL3D32, register here
			Ctl3dAutoSubclass( hInst );
			HelpLoaded = FALSE;				                //  Initialize help flag
													               //  Start main dialog box
         DialogBox( hInst, MAKEINTRESOURCE( 10000 ), hWnd, DeskfontDlgProc );
			Ctl3dUnregister( hInst );			                  //  Kill CTL3D here
         break;

		default:
			break;
	}
   return( 0 );
}

// ---- Main Applet Dialog Box ------------------------------------------------

BOOL WINAPI DeskfontDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
		{
			char str[ 64 ];
			char szValue[ 64 ];
			LONG lStatus;
			HKEY hKey;
			DWORD dwSize, dwType;

			LoadString( hInst, 200, str, 64 );	       //  "Control Panel\\Desktop"
						                         //  Attempt to open key to path above
			lStatus = RegOpenKeyEx( HKEY_CURRENT_USER, str, (DWORD)0,
											KEY_ALL_ACCESS, &hKey );

			if( lStatus != ERROR_SUCCESS )	    //  If it fails, complain and exit
			{
				LoadString( hInst, 102, str, 64 );                  //  "Open Key: "
				ErrorMessageBox( str, TITLE );
				EndDialog( hDlg, FALSE );
				return( TRUE );
			}

			LoadString( hInst, 201, szValue, 64 );        //  "IconVerticalSpacing"

			dwSize = 10;                                //  Get value of V. spacing
			lStatus = RegQueryValueEx( hKey, szValue, (LPDWORD)0, &dwType,
												szValue, &dwSize );
			if( lStatus == ERROR_SUCCESS )	       //  If it worked, display value
				SetDlgItemText( hDlg, 101, szValue );

			LoadString( hInst, 202, szValue, 64 );                //  "IconSpacing"																 	
								                             //  Get value of H. spacing
			dwSize = 10;
			lStatus = RegQueryValueEx( hKey, szValue, (LPDWORD)0, &dwType,
												szValue, &dwSize );
			if( lStatus == ERROR_SUCCESS )
				SetDlgItemText( hDlg, 102, szValue );	            //  Display value

			RegCloseKey( hKey );					           //  Close key and it's done
			return( TRUE );
		}

		case WM_COMMAND:
		{
			if( wParam == IDCANCEL )			          //  Cancel, of course, exits
			{
				EndDialog( hDlg, FALSE );
				return( TRUE );
			}

			if( wParam == 100 )                        //  Change the desktop font?
			{
				ChangeDesktopFont( hDlg );                  //  If so, see this proc
				break;
			}

			if( wParam == IDOK )              //  OK saves current values and exits
			{
				char str[ 64 ];
				char resname[ 64 ];
				char pd[ 16 ];
				HKEY hKey;
				BOOL bJunk;
				int val;
				LONG lStatus;
				DWORD dwSize;

				LoadString( hInst, 203, pd, 16 );		           //  Load for later
				LoadString( hInst, 200, str, 64 );      //  "Control Panel\\Desktop"
						                                 //  Open key using path above
				lStatus = RegOpenKeyEx( HKEY_CURRENT_USER, str, (DWORD)0,
												KEY_ALL_ACCESS, &hKey );
				if( lStatus != ERROR_SUCCESS )				       //  If it bombed...
				{
					LoadString( hInst, 102, str, 64 );               //  "Open Key: "
					ErrorMessageBox( str, TITLE );		  //  Display error and break
					break;
				}
														              //  Get H. spacing value
				val = GetDlgItemInt( hDlg, 102, &bJunk, FALSE );
				wsprintf( str, pd, val );	                    //  Convert to string
				dwSize = lstrlen( str ) + 1;      	       //  Note the double NULLs

				LoadString( hInst, 202, resname, 64 );             //  "IconSpacing"
							                    //  Attempt registry write of new value
				lStatus = RegSetValueEx( hKey, resname, (DWORD)0, REG_SZ, 
												 str, dwSize );
				if( lStatus != ERROR_SUCCESS )       //  Didn't work...display error
				{
					LoadString( hInst, 103, resname, 64 );    //  "Write IconSpacing"
					ErrorMessageBox( resname, TITLE );
				}

				val = GetDlgItemInt( hDlg, 101, &bJunk, FALSE );   //  Go for V size
				wsprintf( str, pd, val );
				dwSize = lstrlen( str ) + 1;      

				LoadString( hInst, 201, resname, 64 );	    //  "IconVerticalSpacing"
				lStatus = RegSetValueEx( hKey, resname, (DWORD)0, REG_SZ, 
												 str, dwSize );
				if( lStatus != ERROR_SUCCESS )
				{
					LoadString( hInst, 104, resname, 64 );	  //  "Write IconVSpacing"
					ErrorMessageBox( resname, TITLE );
				}

				RegCloseKey( hKey );

				if( lStatus != ERROR_SUCCESS )
					break;
									
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			break;
	}
	return( FALSE );
}

// ----------------------------------------------------------------------------

BOOL ChangeDesktopFont( HWND hDlg )
{
	CHOOSEFONT cf;
	LOGFONT lf;
	HKEY hKey;
	HDC hDC;
	BOOL bFlag;
	LONG lStatus;
	char szReg[ 256 ];
	DWORD dwType, dwSize;
	char szValue[ 32 ];
	int len;

	LoadString( hInst, 200, szReg, 64 );             //  "Control Panel\\Desktop"
	memset( (LPVOID)&lf, 0, sizeof(LOGFONT) );	     //  Clear LOGFONT structure
												               //  Attempt to open key above
	lStatus = RegOpenKeyEx( HKEY_CURRENT_USER, szReg, (DWORD)0,
									KEY_ALL_ACCESS, &hKey );
	if( lStatus != ERROR_SUCCESS )		                	     //  Didn't work...
	{
		LoadString( hInst, 102, szReg, 64 );
		ErrorMessageBox( szReg, TITLE );
		return( FALSE );
	}

	bFlag = FALSE;
	LoadString( hInst, 204, szValue, 32 );                //  "IconTitleFaceName"

	dwSize = 32;										    //  Get font name from registry
	lStatus = RegQueryValueEx( hKey, szValue, (LPDWORD)0, &dwType,
										szValue, &dwSize );
	if( lStatus == ERROR_SUCCESS )			          //  If that worked, continue
	{
		lstrcpy( lf.lfFaceName, szValue );
		LoadString( hInst, 205, szValue, 32 )		             //  "IconTitleSize"
		dwSize = 32;									    //  Get font size from registry
		lStatus = RegQueryValueEx( hKey, szValue, (LPDWORD)0, &dwType,
											szValue, &dwSize );
		if( lStatus == ERROR_SUCCESS )			            //  If step 2 worked...
		{
			lf.lfHeight = atol( szValue );
			LoadString( hInst, 206, szValue, 32 );             //  "IconTitleStyle"
			dwSize = 32;				                    //  Get style from registry
			lStatus = RegQueryValueEx( hKey, szValue, (LPDWORD)0, &dwType,
												szValue, &dwSize );
			if( lStatus == ERROR_SUCCESS )
			{
				if( atol( szValue ) )		   //  At this point, we have all we need
					lf.lfWeight = 800;
				else
					lf.lfWeight = 400;
																	  //  Clear CHOOSEFONT struct
				memset( (LPVOID)&cf, 0, sizeof(CHOOSEFONT) );
				hDC = GetDC( hDlg );

				cf.lStructSize = sizeof(CHOOSEFONT);
				cf.hwndOwner = hDlg;
				cf.hDC = hDC;
				cf.lpLogFont = &lf;
				cf.Flags = CF_INITTOLOGFONTSTRUCT | CF_SCREENFONTS;

				bFlag = ChooseFont( &cf );		                //  Display font data
				ReleaseDC( hDlg, hDC );
				if( bFlag )						             //  If user pressed "OK"...
				{
					dwType = REG_SZ;               //  Type is always a plain string
					LoadString( hInst, szReg, 204, 32 );     //  "IconTitleFaceName"
					lstrcpy( szValue, lf.lfFaceName );
					szValue[ lstrlen( szValue ) ] = '\0';	      //  Write font name
					RegSetValueEx( hKey, szReg, 0, dwType, szValue,	 //  to registry
										lstrlen( szValue ) + 1 );

					LoadString( hInst, 205, szReg, 32 );		   //  "IconTitleSize"
					wsprintf( szValue, "%d\0", lf.lfHeight );
					RegSetValueEx( hKey, szReg, 0, dwType, szValue,	  //  Write size
										lstrlen( szValue ) + 1 );

					LoadString( hInst, 206, szReg, 32 );		  //  "IconTitleStyle"
					wsprintf( szValue, "%d\0", ( lf.lfWeight > 400 ) );
					RegSetValueEx( hKey, szReg, 0, dwType, szValue,	 //  Write style
									 	lstrlen( szValue ) + 1 );
				}
			}
		}
	}

	RegCloseKey( hKey );                    //  Close key and font stuff is done!
	return( bFlag );
}	

// ---- One Size Fits All "Oops" Message Box -----------------------------------

BOOL ErrorMessageBox( LPSTR lpszText, LPSTR lpszTitle )
{

   LPSTR lpFormatMessageBuffer;
   DWORD  dwFormatMessage;
   DWORD  dwGetLastError;
   HLOCAL hMessageBoxBuffer;
   LPVOID lpMessageBoxBuffer;

   dwGetLastError = GetLastError();                        //  Get system error

   hMessageBoxBuffer  = LocalAlloc( LMEM_FIXED, 1024 );	   //  Get some memory
   lpMessageBoxBuffer = LocalLock( hMessageBoxBuffer );		    //  for strings
								                        //  Get the system error string
   dwFormatMessage = FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER |
                                    FORMAT_MESSAGE_FROM_SYSTEM, NULL, 
										      dwGetLastError, LANG_NEUTRAL,
                                    (LPSTR)&lpFormatMessageBuffer, 0, NULL );
   if( ! dwFormatMessage )
		return( FALSE );
										                    //  Initialize display string
   wsprintf( lpMessageBoxBuffer, "%s %s", lpszText, lpFormatMessageBuffer );

   MessageBox( NULL, lpMessageBoxBuffer, lpszTitle, 
					MB_ICONEXCLAMATION | MB_OK );

   if( dwFormatMessage )
      LocalFree( (HLOCAL) lpFormatMessageBuffer );

   LocalFree( (HLOCAL) hMessageBoxBuffer );	             //  Clean up and exit
   return( TRUE );
}

// ----------------------------------------------------------------------------
