{===========================================================================}
{ DESIGN   Pascal functions and procedures                                  }
{ (C)      1996   Jeroen van Rooij                                          }
{          (2:285/264.78) or (115:3100/1.4)                                 }
{ UNIT     Design.pas (Design.tpu)                                          }
{ DATE     20-4-1996                                                        }
{ VERSION  1b                                                               }
{ REVISION 28-4-1996                                                        }
{===========================================================================}

{$S-}
Unit Design;

Interface
Type
  ShadowPos     = (none, DnLeft, DnRight, UpLeft, UpRight);
  OpenBoxType   = (non, Horz, Vert);
  ListRec       = Array [1..1000] Of String [30];
  AttrStr       = Record                                       {for MenuBars}
                    len,
                    X, Y   : Byte;
                    Attrs : Array [1..80] Of Byte;
                  End;

Type
  ColorCharSet = Set Of Char;

Const
  ShadowAttr    : Integer = 8;                      {Default attr for shadow}
  DrawSpeed     : Integer = 12;                  {Default speed for OpenBox}
  BoxType       : Integer = 1;                      {Default box type, 1 line}
  SwapOnOff     : Boolean = False;               {Buttonlike boxes}
  DefaultShadow : ShadowPos  = DnRight;
  ShadowOnOff   : Boolean = True;                {Shadow is on when drawing boxes}
  Marker        = '~';
  MarkAttr      : Byte = 14;  {Yellow}

  CuUp     = #72;
  CuDn     = #80;
  CuLe     = #75;
  CuRi     = #77;
  Home     = #71;
  EndKey   = #79;
  PgUp     = #73;
  PgDn     = #81;
  F1       = #59;
  F3       = #61;
  BELL     = #7;
  BS       = #8;
  TB       = #9;
  CR       = #13;
  ESC      = #27;
  DEL      = #83;
  SPACE    = #32;
  NULL     = #0;
  INS      = #82;


Var
  Ascii,
  ScanCode      : Char;
  UpAttr,
  DnAttr        : Byte;
  VBase: Word;

Function BAttr (A: Byte): Byte;
Function CAttr (F, B: Byte): Byte;
Function CharStr (C: Char; Len: Byte): String;
Function ColorOn: Boolean;
Function FAttr (A: Byte): Byte;
Function Key: Word;
Function ListBox (L: ListRec; X1, Y1, X2, Y2, NumFiles, HiliteAttr, NormAttr: Byte): Byte;
Function LoadFont (FileName : String) : Boolean;
Function Menu (X1, Y1, X2, Y2, Attr: Byte): Byte;
Function ScreenAttr (X, Y: Byte): Byte;
Function ScreenChar (X, Y: Byte): Char;
Function ScreenStr (X, Y, Len : Byte): String;

Procedure ClearArea (X1, Y1, X2, Y2, Attr: Byte);
Procedure CWrite (S: String; X, Y, Attr: Byte);
Procedure Delay (ms : Word);
Procedure GotoXY (X, Y : Word);
Procedure HideMenuBar (Var s: AttrStr);

Procedure BoxEngine (X1, Y1, X2, Y2, Attr, Mode: Byte; DrawShadow, inverse: Boolean);
Procedure KeyIn;
Procedure NormalFont;
Procedure OpenBox (X1, Y1, X2, Y2, Attr: Byte; box: OpenBoxType);
Procedure PaintFrame (X1, Y1, X2, Y2, Attr: Byte; inverse: Boolean);
Procedure PaintScreen (C: Char; X1, Y1, X2, Y2, Attr: Byte);
Procedure PopBlock (X1, Y1, X2, Y2: Byte; BlockBuffer: Pointer);
Procedure PushBlock (X1, Y1, X2, Y2: Byte; Var BlockBuffer: Pointer);
Procedure ResetKbd;
Procedure ShowMenuBar (X, Y, len, Attr: Byte; Var s: AttrStr);
Procedure WriteAttr (Attr, X, Y, n, Step: Byte);
Procedure WriteBetween (Str: String; X1, X2, Y, Attr: Byte);
Procedure WriteXy (Str: String; X, Y, Attr: Byte);
Procedure WriteVert (Str: String; X, Y, Attr: Byte);

Implementation

Const
  MaxCharSet = 4;
  CharSet   : Array [0..MaxCharSet] Of String [6] =
  ('      ', 'ڿĳ', 'ɻȼͺ',
  'ոԾͳ', 'ַӽĺ');

Function CAttr (F, B: Byte): Byte;
Begin
  CAttr := (B ShL 4) Or F;
End;

Function FAttr (A: Byte): Byte;
Begin
  FAttr := A And 15;
End;

Function BAttr (A: Byte): Byte;
Begin
  BAttr := (A And 112) ShR 4;
End;

Function ColorOn: Boolean;
Begin
  ColorOn := Vbase = $B800;
End;

Function Key: Word; Assembler;
Asm
  @001:
  Int  28h
  mov  AH, 01h
  Int  16h
  jz   @001
  XOr  AH, AH
  Int  16h
End;

Function KeyPressed: Boolean; Assembler;
Asm
  Int  28h
  Mov AH, 00h
  Int 16h
End;

Procedure KeyIn; Assembler;
Asm
  Call Key
  mov Scancode, AH
  Or  AL, AL
  jz  @001

  @001:
  mov Ascii, AL
End;

Procedure ResetKbd; Assembler;
Asm
  Mov AH, 0CH
  Mov AL, 02h
  Int 21h
End;
Procedure Delay (ms : Word); Assembler;
Asm
  mov AX, 1000
  mul ms
  mov CX, DX
  mov DX, AX
  mov AH, 86h
  Int 15h
End;

Procedure GotoXY (X, Y : Word);
Begin
  Asm
    mov    AX, Y
    mov    DH, AL
    Dec    DH
    mov    AX, X
    mov    DL, AL
    Dec    DL
    mov    AH, 2
    XOr    BH, BH
    Int    10h
  End
End;

Procedure PushBlock (X1, Y1, X2, Y2: Byte; Var BlockBuffer: Pointer);
Type PtrRec = Record
                Ofs: Word;
                Seg: Word;
              End;
Var
  Vofs, MemRequest, nBytes, n: Word;
Begin
  MemRequest := ( (X2 - X1 + 1) * (Y2 - Y1 + 1) ) ShL 1; GetMem (BlockBuffer, MemRequest);
  VOfs := (Y1 * 80 + X1) ShL 1; nBytes := (X2 - X1 + 1) ShL 1;
  For n := Y1 To Y2 Do
  Begin
    Move (Ptr (VBase, VOfs)^, BlockBuffer^, nBytes);
    Inc (VOfs, 160);
    Inc (PtrRec (BlockBuffer).Ofs, nBytes);
  End;
  Dec (PtrRec (BlockBuffer).Ofs, MemRequest);
End;

Procedure PopBlock (X1, Y1, X2, Y2: Byte; BlockBuffer: Pointer);
Type PtrRec = Record
                Ofs: Word;
                Seg: Word;
              End;
Var
  VOfs, MemRequest, nBytes, n : Word;

Begin
  VOfs := (Y1 * 80 + X1) ShL 1; nBytes := (X2 - X1 + 1) ShL 1;
  For n := Y1 To Y2 Do
  Begin
    Move (BlockBuffer^, Ptr (VBase, VOfs)^, nBytes);
    Inc (VOfs, 160);
    Inc (PtrRec (BlockBuffer).Ofs, nBytes);
  End;
  MemRequest := ( (X2 - X1 + 1) * (Y2 - Y1 + 1) ) ShL 1; Dec (PtrRec (BlockBuffer).Ofs, MemRequest);
  FreeMem (BlockBuffer, MemRequest);
End;

Procedure WriteXy (Str: String; X, Y, Attr: Byte);
{Found in SWAG, author unknown}
Var F, B: Byte;
Begin
  F := FAttr (Attr);
  B := BAttr (Attr);
  Asm
    mov DH, Y
    mov DL, X
    XOr AL, AL
    mov AH, b
    mov CL, 4
    ShL AX, CL
    add AH, f
    push AX
    mov BX, 0040h
    mov ES, BX
    mov BX, 0049h
    mov AL, ES: [BX]
    cmp AL, 7
    je @mono_segment
    mov AX, 0b800h
    jmp @got_segment
    @mono_segment:
    mov AX, 0b000h
    @got_segment:
    push AX
    mov BX, 004AH
    XOr CH, CH
    mov CL, ES: [BX]
    XOr AH, AH
    mov AL, DH
    Dec AL
    XOr BH, BH
    mov BL, DL
    Dec BL
    cmp CL, $50
    je @eighty_column
    mul CX
    jmp @multiplied
    @eighty_column:
    mov CL, 4
    ShL AX, CL
    mov DX, AX
    mov CL, 2
    ShL AX, CL
    add AX, DX
    @multiplied:
    add AX, BX
    ShL AX, 1
    mov DI, AX
    lea SI, Str
    SEGSS lodsb
    cmp AL, 00h
    je @done
    mov CL, AL
    XOr CH, CH
    pop ES
    pop AX
    @write_loop:
    SEGSS lodsb
    mov ES: [DI], AX
    Inc DI
    Inc DI
    loop @write_loop
    @done:
  End;
End;

Procedure WriteBetween (Str: String; X1, X2, Y, Attr: Byte);
Var X : Integer;
Begin
  If Length (Str) >= X2 - X1 + 1 Then
    WriteXy (Str, X1, Y, Attr)
  Else
  Begin
    X := X1 + (X2 - X1  - Length (Str) ) Div 2 ;
    WriteXy (Str, X, Y, Attr);
  End;
End;

Procedure WriteVert (Str: String; X, Y, Attr: Byte);
Var
  L: Byte;
  I: Integer;
Begin
  L := Length (Str);
  If L > Succ (25) - Y Then
    L := Succ (25) - Y;
  For I := 1 To L Do
    WriteXy (Str [I], X, Y - 1 + I, Attr);
End;

Function Asc (s: String): Char;
Begin
  ASc := s [1];
End;

Function Swapbool (b: Boolean): Boolean;
Begin
  SwapBool := Not b;
End;


Procedure CWrite (s: String; X, Y, Attr: Byte);
Var
  Len, P: Integer;
  Color: Byte;
  DiffColor: Boolean;
  X2   : Byte;
Begin
  Len := Ord (s [0] ); X2 := X - 1;
  DiffColor := False;
  For p := 1 To Len Do
  Begin
    Case Asc (s [p] ) Of
      Marker :  DiffColor := SwapBool (DiffColor);
      Else Inc (X2);
    End;

    If DiffColor Then Color := Cattr (Fattr (MarkAttr), BAttr (Attr) )
    Else Color := Attr;
    If s [p] <> marker Then WriteXy (s [p], X2, Y, Color);
  End;
End;

Procedure WriteAttr (Attr, X, Y, n, Step: Byte);
Var
  t      : Byte;
  Ofset : Word;
Begin
  If (X >= 0) And (Y >= 0) Then
  Begin
    X := X - 1; Y := Y - 1;
  End;
  Ofset := (Y * 80 + X) ShL 1 + 1;
  For t := 1 To n Do
  Begin
    Move (Attr, Ptr (VBase, OfSet)^, 1);
    Inc (Ofset, Step);
  End;
End;

Function ReadProc (X, Y : Word) : Word; Assembler;
Asm
  Dec   X
  Dec   Y
  mov   AX, Y
  mov   CL, 5
  ShL   AX, CL
  mov   SI, AX
  mov   CL, 2
  ShL   AX, CL
  add   SI, AX
  ShL   X, 1
  add   SI, X

  mov   AX, VBase
  push  DS
  mov   DS, AX
  lodsw
  pop   DS
End;


Function ScreenChar (X, Y: Byte): Char;
Begin
  ScreenChar := Char (Lo (ReadProc (X, Y) ) );
End;

Function ScreenAttr (X, Y: Byte): Byte;
Begin
  ScreenAttr := Hi (ReadProc (X, Y) );
End;

Function ScreenStr (X, Y, Len : Byte): String;
Var
  TempStr: String;
  i     : Integer;
Begin
  TempStr := '';
  For i := 1 To len Do
    TempStr := TempStr + ScreenChar (X + i - 1, Y);
  TempStr [0] := Char (len);
  ScreenStr := TempStr;
End;

Procedure ShowMenuBar (X, Y, len, Attr: Byte; Var s: AttrStr);
Var
  i: Integer;
Begin
  s. len := len;
  s. X  := X;
  s. Y  := Y;
  For i := X To X + len Do s. Attrs [i] := ScreenAttr (i, Y);
  WriteAttr (Attr, X, Y, len, 2);
End;

Procedure HideMenuBar (Var s: AttrStr);
Var
  i: Integer;
Begin
  With s Do
  Begin
    For i := X To X + len Do WriteAttr (Attrs [i], i, Y, 1, 2);
  End;
End;


Function CharStr (C: Char; Len: Byte): String; Assembler;
Asm
  cld
  les  DI, @result
  mov  AL, Len
  Stosb
  XOr  CH, CH
  mov  CL, AL
  mov  AL, C
  rep  stosb
End;

Procedure SwapData (Var Var1, Var2: Byte);
Var
  TempVar: Byte;
Begin
  TempVar := Var1;
  Var1 := Var2;
  Var2 := TempVar;
    End;

Procedure ClearArea (X1, Y1, X2, Y2, Attr: Byte);
Begin
  Asm
    mov AH, 06h
    mov AL, 00h
    mov BH, Attr
    Dec Y1
    Dec X1
    Dec Y2
    Dec X2
    mov CH, Y1
    mov CL, X1
    mov DH, Y2
    mov DL, X2
    Int 10h
  End;
End;

Procedure Shadow (X1, Y1, X2, Y2: Byte; vet: Boolean);
Begin
  Case DefaultShadow Of
    none   : ;
    DnLeft :
            Begin
              WriteAttr (ShadowAttr, X1 - 1, Y2 + 1, X2 - X1, 2);
              WriteAttr (ShadowAttr, X1 - 1, Y1 + 1, Y2 - Y1 + 1, 160);
              If vet Then
                WriteAttr (ShadowAttr, X1 - 2, Y1 + 1, Y2 - Y1 + 1, 160);
            End;
    DnRight:
            Begin
              WriteAttr (ShadowAttr, X1 + 2, Y2 + 1, X2 - X1, 2);
              WriteAttr (ShadowAttr, X2 + 1, Y1 + 1, Y2 - Y1 + 1, 160);
              If vet Then
                WriteAttr (ShadowAttr, X2 + 2, Y1 + 1, Y2 - Y1 + 1, 160);
            End;
    UpLeft :
            Begin
              WriteAttr (ShadowAttr, X1 - 1, Y1 - 1, X2 - X1, 2);
              WriteAttr (ShadowAttr, X1 - 1, Y1 - 1, Y2 - Y1 + 1, 160);
              If vet Then
                WriteAttr (ShadowAttr, X1 - 2, Y1 - 1, Y2 - Y1 + 1, 160);
            End;
    UpRight:
            Begin
              WriteAttr (ShadowAttr, X1 + 2, Y1 - 1, X2 - X1, 2);
              WriteAttr (ShadowAttr, X2 + 1, Y1 - 1, Y2 - Y1 + 1, 160);
              If Vet Then
                WriteAttr (ShadowAttr, X2 + 2, Y1 - 1, Y2 - Y1 + 1, 160);
            End;
  End;
End;

Procedure BoxEngine (X1, Y1, X2, Y2, Attr, Mode: Byte; DrawShadow, inverse: Boolean);
Var
  teken: String [6];
  Color1,
  Color2: Byte;
  AttrFactor: Byte;
Begin
  If Mode > MaxCharSet Then Mode := 1;
  Teken := CharSet [Mode]; AttrFactor := 8;
  If BAttr (Attr) = 1 Then AttrFactor := 10;
  Color1 := CAttr (BAttr (Attr) + AttrFactor, BAttr (Attr) );
  Color2 := CAttr (0, BAttr (Attr) );
  UpAttr := Color1;
  DnAttr := Color2;
  If Inverse Then SwapData (Color1, Color2); ClearArea (X1, Y1, X2, Y2, Attr);
  WriteXy (Teken [1], X1, Y1, Color1); WriteXy (Teken [2], X2, Y1, Color2);       {Hoeken}
  WriteXy (Teken [3], X1, Y2, Color1); WriteXy (Teken [4], X2, Y2, Color2);
  WriteXy (CharStr (Teken [5], X2 - X1 - 1), X1 + 1, Y1, Color1);       {horizontale lijnen}
  WriteXy (CharStr (Teken [5], X2 - X1 - 1), X1 + 1, Y2, Color2);
  WriteVert (CharStr (Teken [6], Y2 - Y1 - 1), X1, Y1 + 1, Color1);       {Verticale lijnen}
  WriteVert (CharStr (Teken [6], Y2 - Y1 - 1), X2, Y1 + 1, Color2);
  If DrawShadow Then Shadow (X1, Y1, X2, Y2, False);
End;

Function Menu (X1, Y1, X2, Y2, Attr: Byte): Byte;
Var
  row  : Integer;
  done : Boolean;
  Bar  : AttrStr;
Begin
  Row := Y1;
  done := False;
  Repeat
    ShowMenuBar (X1, Row, X2 - X1, Attr, Bar);
    KeyIn;
    HideMenuBar (Bar);
    If Ascii = #0 Then
    Begin
      Case Scancode Of
        CuUp  : If row > Y1 Then Dec (row) Else row := Y2;
        CuDn  : If row = Y2 Then row := Y1 Else Inc (row);
        Home  : row := Y1;
        EndKey: row := Y2;
      End;
    End
    Else
    Begin
      Case AScii Of
        Cr :
            Begin menu := row - Y1 + 1; done := True End;
        Esc: Begin menu := 0; done := True; End;
      End;
    End
  Until Done;
End;

Function ListBox (L: ListRec; X1, Y1, X2, Y2, NumFiles, HiliteAttr, NormAttr: Byte): Byte;
Var Len          : Byte;
  Done         : Boolean;
  Pos, First   : Integer;
  Cont         : Integer;
  MenuBar      : Boolean;
  Attr         : Byte;
  Choice       : Byte;
Function squeeze (Str: String; width: Byte): String;
Begin
  If Length (Str) >= width Then
    Str := Copy (Str, 1, width);
  While Length (Str) < width Do
    Str := Str + ' ';
  squeeze := Str;
End;

Begin
  First := 1;
  Pos   := 1;
  Len   := Y2 - Y1;
  Done  := False;
  Choice := 0;
  Repeat
    For Cont := First To First + Len - 1 Do
    Begin
      If (Cont - First + 1 = Pos) Then
      Begin
        MenuBar := True;
      End
      Else
      Begin
        MenuBar := False;
      End;
      If MenuBar Then Attr := HiLiteAttr Else Attr := NormAttr;
      Writexy (Squeeze (L [Cont], X2 - X1), X1, Y1 + Cont - First, Attr);
    End;
    KeyIn;
     If  AScii = #0 Then
      Case Scancode Of
        CuUp: If (Pos > 1)   Then Dec (Pos, 1)
        Else
          If (First > 1) Then Dec (First, 1);
        CuDn: If (Pos < len) Then Inc (Pos, 1)
        Else
          If (First + len < NumFiles) Then Inc (First, 1);
      End
    Else
      Case Ascii Of
        Esc :
              Begin Choice := 0; done := True; End;
        Cr  : Begin if l[Cont - len + Pos] > '' then begin  Choice := Cont - len + Pos; done := True; end; End;
      End;
  Until Done;
  ListBox := Choice;
End;

Procedure PaintFrame (X1, Y1, X2, Y2, Attr: Byte; inverse: Boolean);
Var
  Color1,
  Color2: Byte;
  AttrFactor: Byte;
Begin
  AttrFactor := 8;
  If BAttr (Attr) = 1 Then AttrFactor := 10;
  Color1 := CAttr (BAttr (Attr) + AttrFactor, BAttr (Attr) );
  Color2 := CAttr (0, BAttr (Attr) );
  If Inverse Then SwapData (Color1, Color2);
  WriteAttr (Color1, X1, Y1, X2 - X1, 2);                 {horizontaal boven}
  WriteAttr (Color1, X1, Y1, Y2 - Y1 + 1, 160);           {vertikaal links}
  WriteAttr (Color2, X1 + 1, Y2, X2 - X1, 2);             {horizontaal onder}
  WriteAttr (Color2, X2, Y1, Y2 - Y1 + 1, 160);           {vertikaal rechts}
End;


Procedure OpenBox (X1, Y1, X2, Y2, Attr: Byte; box: OpenBoxType);
Procedure OpenBox1 (X1, Y1, X2, Y2, Attr: Byte);
Var
  Left, Right, CenterX,
  a, b: Integer;
Begin
  CenterX := (X1 + X2) Div 2;
  Left := (X2 - X1) Div 2;
  Right := Left;
  If ( (X2 - X1) Mod 2) > 0 Then Right := Right + 1;
  For a := 1 To Left Do
  Begin
    BoxEngine ( (CenterX - a), Y1, (CenterX + a), Y2, Attr, BoxType, ShadowOnOff, SwapOnOff);
    Delay (DrawSpeed);
  End;
  If Left <> Right Then BoxEngine (X1, Y1, X2, Y2, Attr, BoxType, ShadowOnOff, SwapOnOff);
End;

Procedure OpenBox2 (X1, Y1, X2, Y2, Attr: Byte);
Var
  Up, Down, CenterY,
  a, b: Integer;
Begin
  CenterY := (Y1 + Y2) Div 2;
  Up := (Y2 - Y1) Div 2;
  Down := Up;
  If ( (Y2 - Y1) Mod 2) > 0 Then Down := Down + 1;
  For a := 1 To Up Do
  Begin
    BoxEngine (X1, (CenterY - a), X2, (CenterY + a), Attr, BoxType, ShadowOnOff, SwapOnOff);
    Delay (DrawSpeed * 2);
  End;
  If Up <> Down Then BoxEngine (X1, Y1, X2, Y2, Attr, BoxType, ShadowOnOff, SwapOnOff);
End;

Begin
  Case box Of
    non  : BoxEngine (X1, Y1, X2, Y2, Attr, BoxType, ShadowOnOff, SwapOnOff);
    Horz : OpenBox1 (X1, Y1, X2, Y2, Attr);
    Vert : OpenBox2 (X1, Y1, X2, Y2, Attr);
  End;
End;

Procedure PaintScreen (C: Char; X1, Y1, X2, Y2, Attr: Byte);
Var
  TempStr : String;
  P       : Byte;
Begin
  TempStr := CharStr (c, X2 - X1 + 1);
  For p   := Y1 To Y2 Do WriteXy (TempStr, X1, p, Attr);
End;

Function VideoBase: Word;
Var
  Base : Byte;
Begin
  Asm
    Int 11h
    mov base, AL
  End;
  If (base And 48) = 48 Then VideoBase := $B000                               {Mono}
  Else VideoBase := $B800;                                                   {Kleur}
End;

Function LoadFont (FileName : String) : Boolean;
{(c)1994 Chris Lautenbach                                                   }
Var
  FontFile : File;
  Font, Tmp : Pointer;
  S, O, FontSize, RMSeg, DPSel : Word;
  BPC : Byte;
Begin
  {$I-}
  Assign (FontFile, FileName);
  Reset (FontFile, 1);
  {$I+}
  If (IOResult <> 0) Then
  Begin
    LoadFont := False;
    Exit;
  End;
  FontSize := FileSize (FontFile);
  GetMem (Font, FontSize);
  BlockRead (FontFile, Font^, FontSize);
  BPC := FontSize Div 256;
  Close (FontFile);
  S := Seg (Font^);
  O := Ofs (Font^);
  Asm
    push BP
    mov AL, 10h
    mov AH, 11h
    mov BH, BPC
    mov BL, 00h
    mov CX, 0FFh
    mov DX, 0h
    mov ES, S
    mov BP, O
    Int 10h
    Pop BP
  End;
  FreeMem (Font, FontSize);
  LoadFont := True;
End;

Procedure NormalFont; Assembler;
{(c)1994 Chris Lautenbach                                                   }
 Asm
   mov AL, 04h
   mov AH, 11h
   mov BL, 00h
   Int 10h
 End;

Procedure Copyright; Near; Assembler;
{ This MAY NOT be removed }
Asm
  JMP @@1
  DB 13, 10, 'Design Unit (C) 1996 by Jeroen van Rooij.  All rights reserved.', 13, 10
  @@1:
End;

Begin
  Copyright;
  VBase := VideoBase;
End.
