unit CGIDlg;

interface

uses
  SysUtils,
  WinTypes,
  WinProcs,
  Messages,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Menus,
  StdCtrls,
  ExtCtrls,
  Grids,
  TabNotBk,
  CGI, Buttons;

type
  TCGIDebugDlg = class(TForm)
    ButtonPanel: TPanel;
    InfoNotebook: TTabbedNotebook;
    LFormTuples: TStringGrid;
    LExtraHeaders: TStringGrid;
    LCGIParams: TStringGrid;
    LClientServer: TStringGrid;
    LOutput: TMemo;
    BitBtn1: TBitBtn;
  private
	 { Private declarations }
  public
	 { Public declarations }
  end;

	TTupleGrid = class(TStringGrid)
		procedure AddPair(const Key: String; const Value: String);
		procedure ShowPairs(const Pairs: TTupleList);
	end;

	TCGIDlg = class(TComponent)
	private
		FCGI: TCGI;
		procedure SetCGI(Value: TCGI);
       procedure Notification(AComponent: TComponent; Operation: TOperation); override;
	public
		constructor Create(AOwner: TComponent); override;
       procedure Execute;
	published
		property CGI: TCGI read FCGI write SetCGI;
	end;

implementation

{$R *.DFM}

constructor TCGIDlg.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
end;

procedure TCGIDlg.Execute;
var
	CGIDebugDlg: TCGIDebugDlg;
	SDebug: String;
   POutput: PChar;
begin
	if FCGI = nil then exit;
	CGIDebugDlg := TCGIDebugDlg.Create(Self);
	with FCGI, CGIDebugDlg do begin
		with Profile do begin
			if DebugMode then SDebug := 'Yes' else SDebug := 'No';
			with TTupleGrid(LCGIParams) do begin
				Cells[0,0] := 'Parameter';
				Cells[1,0] := 'Value';
				RowCount := 1;
				AddPair('Debug Mode',SDebug);
               AddPair('Profile File',ProfileFile);
				AddPair('Content File',ContentFile);
				AddPair('Output File',OutputFile);
               AddPair('GMT Offset',IntToStr(GMTOffset));
				AddPair(' ',' ');
				AddPair('CGI Version',Version);
				AddPair('Request Protocol',RequestProtocol);
				AddPair('Request Method',RequestMethod);
				AddPair('Query String',QueryString);
				AddPair('Content Type',ContentType);
				AddPair('Content Length',IntToStr(ContentLength));
				AddPair(' ',' ');
				AddPair('Executable Path',ExecutablePath);
				AddPair('Physical Path',PhysicalPath);
				AddPair('Logical Path',LogicalPath);
				FixedRows := 1;
			end;
			with TTupleGrid(LClientServer) do begin
				Cells[0,0] := 'Parameter';
				Cells[1,0] := 'Value';
				RowCount := 1;
				AddPair('Server Software',ServerSoftware);
				AddPair('Server Name',ServerName);
				AddPair('Server Administrator',ServerAdmin);
				AddPair('Server Port',IntToStr(ServerPort));
				AddPair(' ',' ');
				AddPair('Remote Host',RemoteHost);
				AddPair('Remote Address',RemoteAddr);
				AddPair('Authorized Username',AuthUser);
				AddPair('Authentication Method',AuthType);
				AddPair('RFC-931 Identity',TAPUser);
				FixedRows := 1;
			end;
			with TTupleGrid(LExtraHeaders) do begin
				ShowPairs(ExtraHeaders);
				if RowCount = 1 then RowCount := 2;
				FixedRows := 1;
			end;
           with StdOut do try
					POutput := StrAlloc(Size+3);
					Seek(0,0);
					Read(POutput^,Size);
					LOutput.Lines.SetText(POutput);
				finally
					StrDispose(POutput);
	         end;
		end;
		with TTupleGrid(LFormTuples) do begin
			ShowPairs(FormFields);
			if RowCount = 1 then RowCount := 2;
			FixedRows := 1;
		end;
		CGIDebugDlg.ShowModal;
	end;
end;

procedure TCGIDlg.SetCGI(Value: TCGI);
begin
	if FCGI <> Value then FCGI := Value;
end;

procedure TCGIDlg.Notification(AComponent: TComponent; Operation: TOperation);
begin
	inherited Notification(AComponent, Operation);
   if (Operation = opRemove) and (AComponent = FCGI) then
   	FCGI := nil;
end;

{ TTupleGrid implementations }

procedure TTupleGrid.AddPair(const Key: String; const Value: String);
begin
	if Cells[0,RowCount - 1] <> '' then RowCount := RowCount + 1;
	Cells[0,RowCount - 1] := Key;
	Cells[1,RowCount - 1] := Value;
end;

procedure TTupleGrid.ShowPairs(const Pairs: TTupleList);
var
	i: Integer;
begin
	with Pairs do begin
		RowCount := Count + 1;
		Cells[0,0] := 'Key';
		Cells[1,0] := 'Value';
		for i := 0 to Count - 1 do begin
			Cells[0,i+1] := Keys[i];
			Cells[1,i+1] := Values[Keys[i]];
		end;
	end;
end;

end.
