PROGRAM Delete0ByteFiles;
{$M 1536,0,0}  { 1.5k reserved for data }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}
{$S- no stack checking needed here}

USES DOS;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath)] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath)] IN [':', '\']) THEN
    jPath := jPath + '*.*';

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;

  sDir := jDir;
  GetFilePath := jPath;
END;

CONST
  NL = #13#10;
VAR
  fPath     : PATHSTR;
  fDir      : DIRSTR;
  DirInfo   : SEARCHREC;
  fFile     : FILE;
  Deleted   : WORD;

BEGIN
  WriteLn ('DEL0 v1.10 - Free DOS utility: Zero byte file deleter.');
  WriteLn ('September 29, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.' + NL);

  Deleted := 0;
  IF ParamCount <> 1 THEN
  BEGIN
    WriteLn ('Usage: DEL0 FileMask');
    Halt (1);
  END;
  fPath := GetFilePath (ParamStr (1), fDir);

  FindFirst (fPath, Archive, DirInfo);
  WHILE DosError = 0 DO
  BEGIN
    fPath := fDir + DirInfo. Name;
    Assign (fFile, fPath);
    IF (DirInfo. Size = 0) THEN BEGIN
      Write ('Deleting ', fPath);
      Erase (fFile);
      IF IOResult = 0
        THEN WriteLn (', done!')
        ELSE WriteLn (' - unable to delete.');
      Inc (Deleted)
    END;

    FindNext (DirInfo);
  END;
  IF Deleted > 0 THEN WriteLn;
  WriteLn ('Files deleted: ', Deleted);
END.
