/*=================================================================
Microsoft Jet

Microsoft Confidential.  Copyright 1991 Microsoft Corporation.

Component: Microsoft Access Data Dictionary Library

File: msa_ddl.h - MS Access DDL public API

File Comments:

Revision History:

	[0]  03-Nov-92	a-MarkB		Created

=================================================================*/

#if !defined(_MSADDL_INCLUDED)
#define _MSADDL_INCLUDED

#ifdef	__cplusplus
extern "C" {
#endif

#pragma pack(2)

#define ACCESSDDL_PUBLIC	_loadds _far _pascal


typedef long ACCESSDDL_ERR;
typedef unsigned long ACCESSDDL_TABLEID;	/* Table Identifier */
typedef unsigned long ACCESSDDL_DBID;		/* Database Identifier */
typedef unsigned long ACCESSDDL_GRBIT;		/* Group of Bits */
typedef unsigned long ACCESSDDL_FIELDTYPE;	/* Field Type */


#define ACCESSDDL_bitIndexUnique		0x00000001
#define ACCESSDDL_bitIndexPrimary		0x00000002

#define ACCESSDDL_ReferenceUnique		0x00000001
#define ACCESSDDL_ReferenceDontEnforce	0x00000002


#define ACCESSDDL_fieldtypeYesNo		1
#define ACCESSDDL_fieldtypeByte			2
#define ACCESSDDL_fieldtypeInteger		3
#define ACCESSDDL_fieldtypeLongInteger	4
#define ACCESSDDL_fieldtypeCurrency		5
#define ACCESSDDL_fieldtypeSingle		6
#define ACCESSDDL_fieldtypeDouble		7
#define ACCESSDDL_fieldtypeDateTime		8
#define ACCESSDDL_fieldtypeText			10
#define ACCESSDDL_fieldtypeOLE			11
#define ACCESSDDL_fieldtypeMemo			12



ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLStartEngine(
	const char _far *szSystemFileName,
	const char _far *szINIFileName,
	const char _far *szUserName,
	const char _far *szPassword);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLOpenDatabase(
	const char _far *szDatabase,
	ACCESSDDL_DBID _far *pdbid);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLCloseDatabase(
	ACCESSDDL_DBID dbid);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLOpenTable(
	ACCESSDDL_DBID dbid,
	const char _far *szTableName,
	ACCESSDDL_TABLEID _far *ptableid);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLCreateTable(
	ACCESSDDL_DBID dbid,
	const char _far *szTableName,
	ACCESSDDL_TABLEID _far *ptableid);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLDeleteTable(
	ACCESSDDL_DBID dbid,
	const char _far *szTableName);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLRenameTable(
	ACCESSDDL_DBID dbid,
	const char _far *szTableName,
	const char _far *szTableNew);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLCloseTable(
	ACCESSDDL_TABLEID tableid);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLAddField(
	ACCESSDDL_DBID dbid,
	ACCESSDDL_TABLEID tableid,
	const char _far *szFieldName,
	ACCESSDDL_FIELDTYPE fieldtype,
	unsigned long cbMax,
	int fAutoincr);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLDeleteField(
	ACCESSDDL_TABLEID tableid,
	const char _far *szFieldName);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLRenameField(
	ACCESSDDL_TABLEID tableid,
	const char _far *szFieldName,
	const char _far *szFieldNew);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLCreateIndex(
	ACCESSDDL_TABLEID tableid,
	const char _far *szIndexName,
	ACCESSDDL_GRBIT grbit,
	const char _far *szKey);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLDeleteIndex(
	ACCESSDDL_TABLEID tableid,
	const char _far *szIndexName);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLRenameIndex(
	ACCESSDDL_TABLEID tableid,
	const char _far *szIndexName,
	const char _far *szIndexNew);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLCreateReference(
	ACCESSDDL_TABLEID tableid,
	const char _far *szReferenceName,
	const char _far *szFields,
	const char _far *szReferencedTable,
	const char _far *szReferencedFields,
	ACCESSDDL_GRBIT grbit);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLDeleteReference(
	ACCESSDDL_TABLEID tableid,
	const char _far *szReferenceName);

ACCESSDDL_ERR ACCESSDDL_PUBLIC AccessDDLStopEngine(
	void);



/* SUCCESS */

#define ACCESSDDL_errSuccess				 0		/* Successful Operation */

/* ERRORS */

#define ACCESSDDL_wrnNYI					-1		/* Function Not Yet Implemented */

#define ACCESSDDL_errAccessDenied			-1907	/* Access denied */
#define ACCESSDDL_errAlreadyInitialized		-1030	/* Engine already started */
#define ACCESSDDL_errDatabaseCloseError 	-1806	/* Db file could not be closed */
#define ACCESSDDL_errDatabaseInvalidName	-1204	/* Invalid database name */
#define ACCESSDDL_errDatabaseNotFound		-1203	/* No such database */
#define ACCESSDDL_errField2ndSysMaint		-1510	/* Second autoinc or version field */
#define ACCESSDDL_errFieldCannotIndex		-1513	/* Cannot index Bit,LongText,LongBinary */
#define ACCESSDDL_errFieldDuplicate			-1508	/* Field is already defined */
#define ACCESSDDL_errFieldIndexed			-1505	/* Field indexed, cannot delete */
#define ACCESSDDL_errFieldInUse 			-1046	/* Field used in an index */
#define ACCESSDDL_errFieldNotFound			-1507	/* No such field */
#define ACCESSDDL_errFieldTooBig			-1506	/* Field length is > maximum */
#define ACCESSDDL_errFileAccessDenied		-1032	/* File Access Denied */
#define ACCESSDDL_errFileNotFound			-1811	/* File not found */
#define ACCESSDDL_errIllegalOperation		-1312	/* Oper. not supported on table */
#define ACCESSDDL_errIndexDuplicate 		-1403	/* Index is already defined */
#define ACCESSDDL_errIndexHasPrimary		-1402	/* Primary index already defined */
#define ACCESSDDL_errIndexInUse 			-1051	/* Index used in a reference */
#define ACCESSDDL_errIndexNotFound			-1404	/* Specified index not found */
#define ACCESSDDL_errInvalidAccountName 	-1903	/* Invalid account name */
#define ACCESSDDL_errInvalidDatabase		-1028	/* This isn't a database */
#define ACCESSDDL_errInvalidDatabaseId		-1010	/* Invalid database id */
#define ACCESSDDL_errInvalidFieldType		-1511	/* Invalid field data type */
#define ACCESSDDL_errInvalidLogon			-1902	/* Invalid username or password */
#define ACCESSDDL_errInvalidName			-1002	/* Invalid database name */
#define ACCESSDDL_errInvalidParameter		-1003	/* Invalid API parameter */
#define ACCESSDDL_errInvalidPassword		-1905	/* Invalid password */
#define ACCESSDDL_errInvalidPath			-1023	/* Pathname was invalid or nonexistent */
#define ACCESSDDL_errInvalidTableId 		-1310	/* Invalid table id */
#define ACCESSDDL_errLinkNotSupported		-1052	/* Link support unavailable */
#define ACCESSDDL_errNotInitialized			-1029	/* StartEngine not yet called */
#define ACCESSDDL_errObjectNotFound 		-1305	/* No such table or object */
#define ACCESSDDL_errPermissionDenied		-1809	/* Permission denied */
#define ACCESSDDL_errSelfReference			-1407	/* Referencing/Referenced index is the same */
#define ACCESSDDL_errTableDuplicate 		-1303	/* Table already exists */
#define ACCESSDDL_errTableInUse 			-1304	/* Table is in use, cannot lock */
#define ACCESSDDL_errTooManyFields			-1040	/* Too many fields defined */
#define ACCESSDDL_errTooManyKeys			-1016	/* Too many fields in an index */
#define ACCESSDDL_errTooManyOpenFiles		-1807	/* Too many files open */
#define ACCESSDDL_errTooManyTasks			-20001	/* Too many concurrent DDL tasks */



#pragma pack()

#ifdef	__cplusplus
}
#endif

#endif	/* _MSADDL_INCLUDED */
