/* SDI for CoolWorx -- Williams */

#include <windows.h>
#include <commdlg.h>
#include "coolworx.h"
#include "cwh.h"

/* SDI Default Window Procedure */
LONG WINAPI _export cw_DefWindowProc(HWND w,UINT msg,
  UINT wParam, LONG lParam)
  {
  switch (msg)
    {
/* Convert CLOSE to QUERYENDSESSION */
    case WM_CLOSE:
/* Nonstandard parameter 1 just in case you want to
   know what is happening. The debug kernel will
   complain but it is harmless */
      if (SendMessage(w,WM_QUERYENDSESSION,1,0))
        {
        DestroyWindow(w);
        }
      return 0;

/* Convert CM_FILEEXIT to close
   NOTE: if you don't want this behavior simply catch
   CM_FILEEXIT and don't call this routine */
    case WM_COMMAND:
      if (wParam==CM_FILEEXIT)
        SendMessage(w,WM_CLOSE,0,0);
      break;
    }
  return DefWindowProc(w,msg,wParam,lParam);
  }

/* Create an SDI window */
HWND WINAPI _export cw_SDICreate(LPCSTR title,LPCSTR menu,
   HANDLE hInst,
   FARPROC cb,LPCSTR top,LPCSTR left,LPCSTR right,
   LPCSTR bot,LONG lParam)
   {
   HWND w;
   w=CreateWindow("CWSDIClass",title,WS_OVERLAPPEDWINDOW,
     CW_USEDEFAULT,0,CW_USEDEFAULT,0,NULL,
     LoadMenu(hInst,menu),hInst,cb);
  if (w)
    {
    if (top) cw_Ribbon(top,w,CWRIBBON_TOP);
    if (bot) cw_Ribbon(bot,w,CWRIBBON_BOTTOM);
    if (right) cw_Ribbon(right,w,CWRIBBON_RIGHT);
    if (left) cw_Ribbon(left,w,CWRIBBON_LEFT);
    SendMessage(w,CW_SDICREATE,0,0);  // do create
    SendMessage(w,CW_IDLE,0,0);  // update toolbars
    }
  return w;
  }
