;
;                80386/80486 exceptions
;
DIVIDE_ERROR    EQU     0       ; fault
DEBUGGER_INT    EQU     1       ; fault or trap
NONMASKABLE_INT EQU     2       ; interrupt
BREAKPOINT      EQU     3       ; trap
OVERFLOW_INT    EQU     4       ; trap - interrupt on overflow ( INTO )
BOUND_VIOLATION EQU     5       ; fault - array boundary violation ( BOUND )
INVALID_OPCODE  EQU     6       ; fault
MATH_NOT_AVL    EQU     7       ; fault - coprocessor not available
DOUBLE_FAULT    EQU     8       ; abort
MATHSEG_OVERRUN EQU     9       ; coprocessor segment overrun (reserved on 486)
INVALID_TSS     EQU     10      ; fault
SEG_NOT_PRESENT EQU     11      ; fault
STACK_EXCEPTION EQU     12      ; fault
GENERAL_PROTECT EQU     13      ; fault - General Protection Violation
PAGE_FAULT      EQU     14      ; fault
RESERVED_EXCEPT EQU     15
MATH_ERROR      EQU     16      ; fault - coprocessor error
ALIGNMENT_CHECK EQU     17      ; fault - ( 80486 only )

;
;
;                   Task Segment State
;
TSS_386         STRUC
 TSS_BACK_LINK   DW      ?       ; Selector of the TSS previously executing
                 DW      0
 TSS_ESP0        DD      ?       ; ESP for RING 0 execution
 TSS_SS0         DW      ?       ; SS for RING 0 execution
                 DW      0
 TSS_ESP1        DD      ?       ; ESP for RING 1 execution
 TSS_SS1         DW      ?       ; SS for RING 1 execution
                 DW      0
 TSS_ESP2        DD      ?       ; ESP for RING 2 execution
 TSS_SS2         DW      ?       ; SS for RING 2 execution
                 DW      0
 TSS_CR3         DD      ?       ; Task CR3 ( page directory address )
 TSS_EIP         DD      ?       ; Task EIP
 TSS_EFLAGS      DD      ?       ; Task EFLAGS register
 TSS_EAX         DD      ?
 TSS_ECX         DD      ?
 TSS_EDX         DD      ?
 TSS_EBX         DD      ?
 TSS_ESP         DD      ?
 TSS_EBP         DD      ?
 TSS_ESI         DD      ?
 TSS_EDI         DD      ?
 TSS_ES          DW      ?
                 DW      0
 TSS_CS          DW      ?
                 DW      0
 TSS_SS          DW      ?
                 DW      0
 TSS_DS          DW      ?
                 DW      0
 TSS_FS          DW      ?
                 DW      0
 TSS_GS          DW      ?
                 DW      0
 TSS_LDTR        DW      ?       ; Selector for the task LDT
                 DW      0
 TSS_TRAP_WORD   DW      ?       ; contains T bit ( trap on task switch )
 TSS_IOBP        DW      ?       ; a base of IO permission bitmap
TSS_386         ENDS

;
;               CR0 (control register 0) breakdown -- not in VMM.inc
;
NE_Bit  EQU     00000000000000000000000000100000B       ; Numeric exception
WP_Bit  EQU     00000000000000010000000000000000B       ; Write protect
AM_Bit  EQU     00000000000001000000000000000000B       ; Alignment mask
NW_Bit  EQU     00100000000000000000000000000000B       ; No write-through
CD_Bit  EQU     01000000000000000000000000000000B       ; Cache disable

;
;                  Segment Descriptors
;
SEGDESCRIPTOR   STRUC
 Seg_Desc_Limit_0_15   DW      ?               ; Limit bits 0 - 15
 Seg_Desc_Base_0_23    DW      ?               ; Base BITS 0 - 15
 Seg_Desc_Base_16_23   DB      ?               ; Base BITS 16 - 23
 Seg_Desc_Access_Right DB      ?               ; Access right byte
 Seg_Desc_Gran_Byte    DB      ?               ; Granularity, etc
 Seg_Desc_Base_24_31   DB      ?               ; Base bits 24 - 31
SEGDESCRIPTOR   ENDS

CALLGATEDESCRPT STRUC
 Gate_Offset_O_15      DW      ?               ; offset, low 16
 Gate_Selector         DW      ?               ; selector
 Gate_DWord_Count      DB      ?               ; (D)Word parameter count
 Gate_Access_Rights    DB      ?               ; present,dpl,system,type
 Gate_Offset_16_31     DW      ?               ; offset, upper 16
CALLGATEDESCRPT ENDS

; call gate upper dword
CGATE_OFFSET_16_31_MASK         equ     0FFFF0000h
CGATE_ACCESS_RIGHTS_MASK        equ     0FF00h
CGATE_DWORD_COUNT_MASK          equ     0FFh
; call gate lower dword
CGATE_SELECTOR_MASK             equ     0FFFF0000h
CGATE_OFFSET_0_15_MASK          equ     0FFFFh

DESC_TYPE_MASK  equ     00001111B       ; TYPE field for system and gate descriptors

DESC_TYPE_UNUSED        equ     0       ; invalid descriptor
DESC_TYPE_286_TSS       equ     1       ; 80286 TSS descriptor
DESC_TYPE_LDT           equ     2
DESC_TYPE_BUSY_286_TSS  equ     3
DESC_TYPE_286_CALL_GATE equ     4
DESC_TYPE_TASK_GATE     equ     5
DESC_TYPE_286_INT_GATE  equ     6
DESC_TYPE_286_TRAP_GATE equ     7
DESC_TYPE_386_TSS       equ     9       ; 80386/80486 TSS
DESC_TYPE_BUSY_386_TSS  equ     11      ; 80386/80486 busy TSS
DESC_TYPE_386_CALL_GATE equ     12      ; 80386/80486 call gate
DESC_TYPE_386_INT_GATE  equ     14      ; 80386/80486 interrupt gate
DESC_TYPE_386_TRAP_GATE equ     15      ; 80386/80486 trap gate

GATE32_RING3    equ     (D_PRES+D_DPL3+D_CTRL+DESC_TYPE_386_CALL_GATE) shl 8
GATE16_RING3    equ     (D_PRES+D_DPL3+D_CTRL+DESC_TYPE_286_CALL_GATE) shl 8

CALLGATE_DDCOUNT_MASK   equ     1fh     ; dword count < 32
