program SingleExample;

uses
	(* we need this unit for two things; first, all run-time errors
	are transformed into trappable exceptions, and second, we will
	be able to query the status of the heap so that we can check
	whether the objects have leaked *)
	SysUtils,
	(* these are the units in which the objects are implemented *)
	Employee in 'Employee.pas',
	EmployeeCaller in 'EmployeeCaller.pas',
	Programmer in 'Programmer.pas';

(* we'll use this procedure as an opportunity to shown
polymorphism; we only need a TEmployee to fire *)
procedure Fire( Employee : TEmployee );
begin
	Employee.Destroy;
end;

var
	Programmer	:	TProgrammer;

begin
	(* we write out the amount of free memory on the heap before
	creation and after destruction of the object. if these two
	are different, we've had a memory leak *)
	writeln( 'Start (', GetHeapStatus.TotalFree, ' bytes free).' );
	try
		Programmer := TProgrammer.Create;
	except
		writeln( 'Error!' );
		readln;
		halt;
	end;
	writeln( 'Running. (', GetHeapStatus.TotalFree,
		' bytes free).' );
	try
		Fire( Programmer.AsEmployee );
	except
		writeln( 'Error!' );
		readln;
		halt;
	end;
	writeln( 'End (', GetHeapStatus.TotalFree, ' bytes free).' );
	readln;
end.
