unit ProgrammerCaller;         
interface
uses Programmer;
type
	(* the purpose of the TProgrammerCaller class is to provide
	methods that call the virtual methods in the base class.
	this is necessary as we cannot use the 'inherited' keyword.
	this function has no extra members so we can use the base
	class' constructor.
	none of the methods are virtual. their purpose is to call
	the implementation in the base class. hence, we don't want
	anyone to override that behavior. *)
	TProgrammerCaller	=	class( TProgrammer )
		public
			(* notice that the destructor is not declared as a
			destructor, but as a regular procedure. this is done
			because we want to be able to call the method that
			properly takes down the base class, without calling
			a destructor (which will free memory) *)
			procedure InheritedDestroy;
			(* we create an extra method for every virtual method
			there is in the base class, since somewhere down the
			class tree, someone may want to override it (and also
			call the ancestor) *)
			procedure InheritedWork( Hours : integer );
			function InheritedWage : real;
			function InheritedLinesWritten : integer;
	end;

implementation

(* the implementation of these classes are straight-forward... *)
procedure TProgrammerCaller.InheritedDestroy;
begin
	inherited Destroy;
end;

procedure TProgrammerCaller.InheritedWork;
begin
	inherited Work( Hours );
end;

function TProgrammerCaller.InheritedWage;
begin
	Result	:=	inherited Wage;
end;

function TProgrammerCaller.InheritedLinesWritten;
begin
	Result	:=	inherited LinesWritten;
end;

end.
