program MultipleExample;

uses
	(* we need this unit for two things; first, all run-time errors
	are transformed into trappable exceptions, and second, we will
	be able to query the status of the heap so that we can check
	whether the objects have leaked *)
	SysUtils,
	Employee in 'Employee.pas',
	EmployeeCaller in 'EmployeeCaller.pas',
	Programmer in 'Programmer.pas',
	ProgrammerCaller in 'ProgrammerCaller.pas',
	Manager in 'Manager.pas',
	ManagerCaller in 'ManagerCaller.pas',
	Lead in 'Lead.pas';

procedure Code( AProgrammer : TProgrammer );
begin
	AProgrammer.Work( 8 );
end;

procedure Manage( AManager : TManager );
begin
	AManager.Work( 8 );
end;

var
	Lead	:	TLead;

begin
	(* we write out the amount of free memory on the heap before
	creation and after destruction of the object. if these two
	are different, we've had a memory leak *)
	Writeln( GetHeapStatus.TotalFree, ' bytes free.' );
	try
		Lead	:=	TLead.Create;
		Writeln( GetHeapStatus.TotalFree, ' bytes free.' );
		Code( Lead.AsProgrammer );
		Manage( Lead.AsManager );
		Writeln( Lead.LinesWritten, ' lines written.' );
		Writeln( Lead.PlansMade, ' plans made.' );
		Writeln( Lead.Wage:3:2, ' dollars earned.' );
		Lead.Destroy;
	except
		Writeln( 'Error!' );
		Readln;
		Halt;
	end;
	Writeln( GetHeapStatus.TotalFree, ' bytes free.' );
	readln;
end.
