unit Employee;
interface
type
	(* the TEmployee class is a simple base class that we want to
	inherit from and override characteristics *)
	TEmployee	=	class
		public
			constructor Create( Salary : real );
			destructor Destroy; override;
			(* these functions modify or query the properties of the
			object *)
			procedure Work( Hours : integer ); virtual;
			function Wage	: real; virtual;
		private
			m_HoursWorked	:	integer;
			m_Salary			:	real;
	end;

implementation

constructor TEmployee.Create;
begin
	(* initialize the members of the objects first *)
	m_Salary 		:= Salary;
	m_HoursWorked	:=	0;
	(* give a debug message so that we know the order of
	initialization *)
	writeln( 'DEBUG: Employee created.' );
end;

destructor TEmployee.Destroy;
begin
	writeln( 'DEBUG: Employee destroyed.' );
end;

procedure TEmployee.Work;
begin
	inc( m_HoursWorked, Hours );
end;

function TEmployee.Wage;
begin
	Result	:= m_Salary * m_HoursWorked;
end;

end.
