// ---- midiout.cpp

#include "stdafx.h"
#include "midifitz.h"
#include "midifdlg.h"

MidiOut::MidiOut(short int outputdevice)
{
    hMidiOut = 0;
	numDevices = 0;
	// ---- test for MIDI input devices
    if ((numDevices = midiOutGetNumDevs()) == 0)
		throw("No MIDI output devices");
	MIDIOUTCAPS ocaps;
	midimapper =
		!midiOutGetDevCaps((unsigned)MIDIMAPPER, &ocaps, sizeof(ocaps));
	if (midimapper)
		--outputdevice;
	currDevice = outputdevice;
	if (midiOutOpen(&hMidiOut, currDevice, 0, 0L, 0L))
		throw ("Cannot open MIDI output device");
}

MidiOut::~MidiOut()
{
	if (hMidiOut != 0)
		midiOutClose(hMidiOut);
}
void MidiOut::ChangeDevice(short int device)
{
	if (midimapper)
		--device;
	ASSERT(device < numDevices);
	if (device != currDevice)	{
		midiOutClose(hMidiOut);
		currDevice = device;
		if (midiOutOpen(&hMidiOut, currDevice, 0, 0L, 0L))
			throw("Cannot open MIDI output device");
	}
}
void MidiOut::SetPatch(short int channel, short int voice)
{
     DWORD mmsg  = 0xc0 | channel | (voice << 8);
     midiOutShortMsg(hMidiOut, mmsg);
}
void MidiOut::NoteOn(short int channel, short int note, short int velocity)
{
     DWORD mmsg  = 0x90 | channel | (note << 8) | (velocity << 16);
     midiOutShortMsg(hMidiOut, mmsg);
}
void MidiOut::NoteOff(short int channel, short int note, short int velocity)
{
     DWORD mmsg  = 0x80 | channel | (note << 8) | (velocity << 16);
     midiOutShortMsg(hMidiOut, mmsg);
}
void MidiOut::Pedal(short int channel, short int pedal, short int velocity)
{
     DWORD mmsg  = 0xB0 | channel | (pedal << 8) | (velocity << 16);
     midiOutShortMsg(hMidiOut, mmsg);
}
void MidiOut::StartMessage()
{
     DWORD mmsg  = 0xfa;
     midiOutShortMsg(hMidiOut, mmsg);
}
void MidiOut::TimingMessage()
{
     DWORD mmsg  = 0xf8;
     midiOutShortMsg(hMidiOut, mmsg);
}
void MidiOut::StopMessage()
{
     DWORD mmsg  = 0xfc;
     midiOutShortMsg(hMidiOut, mmsg);
}
void MidiOut::DeviceList(CComboBox* dlist)
{
	ASSERT(dlist != 0);
	MIDIOUTCAPS ocaps;
	if (midimapper)
		dlist->AddString("MIDI Mapper");
	for (short int i = 0; i < numDevices; i++)	{
		midiOutGetDevCaps(i, &ocaps, sizeof(ocaps));
		dlist->AddString(ocaps.szPname);
	}
}
