// midifitz.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "midifitz.h"
#include "midifdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMidifitzApp

BEGIN_MESSAGE_MAP(CMidifitzApp, CWinApp)
	//{{AFX_MSG_MAP(CMidifitzApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMidifitzApp construction

CMidifitzApp::CMidifitzApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMidifitzApp object

CMidifitzApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMidifitzApp initialization

BOOL CMidifitzApp::InitInstance()
{
	Enable3dControls();
	SetDialogBkColor();
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)
	// ---- .INI variables
	int pianovoice, pianovolume;
	int bassvoice, bassvolume;
	int outputdevice;
	CString sync, leadin, autopilot;
	// ----- load .INI variables
	pianovoice = GetProfileInt("Piano", "Instrument", 1);
	pianovolume = GetProfileInt("Piano", "Volume", 32);
	bassvoice = GetProfileInt("Bass", "Instrument", 32);
	bassvolume = GetProfileInt("Bass", "Volume", 32);
	outputdevice = GetProfileInt("MIDIOut", "Device", 0);
	sync = GetProfileString("Settings", "Sync", "External");
	leadin = GetProfileString("Settings", "Leadin", "true");
	autopilot = GetProfileString("Settings", "Autopilot", "true");
	BOOL issync = (sync == "External");
	BOOL isleadin = (leadin == "true");
	BOOL isautopilot = (autopilot == "true");
	// ---- instantiate dialog application
	CMidifitzDlg dlg(pianovoice, pianovolume,
					 bassvoice, bassvolume,
					 outputdevice,
					 issync,
					 isleadin,
					 isautopilot);
	m_pMainWnd = &dlg;
	try {
		// ---- execute the application
		dlg.DoModal();
	}
	catch (char* msg) {
		MessageBeep(MB_ICONSTOP);
    	MessageBox(NULL, msg, ApplTitle, MB_OK | MB_ICONEXCLAMATION);
	}
	// ---- update the .INI file
	sync = issync ? "External" : "Internal";
	leadin = isleadin ? "true" : "false";
	autopilot = isautopilot ? "true" : "false";
	BOOL rtn = WriteProfileInt("Piano", "Instrument", pianovoice);
	WriteProfileInt("Piano", "Volume", pianovolume);
	WriteProfileInt("Bass", "Instrument", bassvoice);
	WriteProfileInt("Bass", "Volume", bassvolume);
	WriteProfileInt("MIDIOut", "Device", outputdevice);
	WriteProfileString("Settings", "Sync", sync);
	WriteProfileString("Settings", "Leadin", leadin);
	WriteProfileString("Settings", "Autopilot", autopilot);
	return FALSE;
}
