/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __TK_TAGMANAGER__
#define __TK_TAGMANAGER__

#ifndef __TK_PACKEROBJECT__
#include "TK_PackerObject.h"
#endif
#ifndef __TK_STORABLEOBJECT__
#include "TK_StorableObject.h"
#endif

/* This Tag Manager handles the attachment and removal of specific types
   of tag data: Boolean's, Rectangles, etc.
 */

SN_Error TK_AttachLong(FT_TaggableObject& rObject, FT_TagName tagName, long tagData);
SN_Error TK_AttachRectangle(FT_TaggableObject& rObject, FT_TagName tagName, Rect& rTagData);
SN_Error TK_AttachReference(FT_TaggableObject& rObject, FT_TagName tagName, void* tagData);
SN_Error TK_AttachRGBColor(FT_TaggableObject& rObject, FT_TagName tagName, RGBColor& rTagData);
SN_Error TK_AttachPascalString(FT_TaggableObject& rObject, FT_TagName tagName, Str255 tagData);
SN_Error TK_AttachShort(FT_TaggableObject& rObject, FT_TagName tagName, short tagData);
SN_Error TK_AttachBoolean(FT_TaggableObject& rObject, FT_TagName tagName, Boolean tagData);
SN_Error TK_AttachCharacter(FT_TaggableObject& rObject, FT_TagName tagName, char tagData);
SN_Error TK_AttachData(FT_TaggableObject& rObject, FT_TagName tagName, void* pTagData, FT_TagDataSize dataSize);
SN_Error TK_AttachPoint(FT_TaggableObject& rObject, FT_TagName tagName, Point tagData);

SN_Error TK_RetrieveLong(FT_TaggableObject& rObject, FT_TagName tagName, long& rTagData);
SN_Error TK_RetrieveRectangle(FT_TaggableObject& rObject, FT_TagName tagName, Rect& rTagData);
SN_Error TK_RetrieveReference(FT_TaggableObject& rObject, FT_TagName tagName, void*& rpTagData);
SN_Error TK_RetrieveRGBColor(FT_TaggableObject& rObject, FT_TagName tagName, RGBColor& rTagData);
SN_Error TK_RetrievePascalString(FT_TaggableObject& rObject, FT_TagName tagName, StringPtr pTagData);
SN_Error TK_RetrieveShort(FT_TaggableObject& rObject, FT_TagName tagName, short& rTagData);
SN_Error TK_RetrieveBoolean(FT_TaggableObject& rObject, FT_TagName tagName, Boolean& rTagData);
SN_Error TK_RetrieveCharacter(FT_TaggableObject& rObject, FT_TagName tagName, char& rTagData);
SN_Error TK_RetrieveData(FT_TaggableObject& rObject, FT_TagName tagName, Handle& rhTagData);
SN_Error TK_RetrievePoint(FT_TaggableObject& rObject, FT_TagName tagName, Point& rTagData);

long TK_RetrieveLong(FT_TaggableObject& rObject, FT_TagName tagName);
Rect TK_RetrieveRectangle(FT_TaggableObject& rObject, FT_TagName tagName);
void* TK_RetrieveReference(FT_TaggableObject& rObject, FT_TagName tagName);
RGBColor TK_RetrieveRGBColor(FT_TaggableObject& rObject, FT_TagName tagName);

SN_Error TK_AttachPackedStorableObject(FT_TaggableObject& rObject, TK_StorableObject& rStorableObject, FT_TagName tagName, FT_TagType tagType);
SN_Error TK_RetrievePackedStorableObject(FT_TaggableObject& rObject, FT_TagName tagName, FT_TagData& rTagData);

FT_TagType TK_GetPackedTagType(FT_TagData packedTag);
FT_TagName TK_GetPackedTagName(FT_TagData packedTag);
FT_TagDataSize TK_GetPackedTagDataSize(FT_TagData packedTag);

#endif
