/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __TK_TAGMANAGER__
#include "TK_TagManager.h"
#endif
#ifndef __FT_TAGMANAGER__
#include "FT_TagManager.h"
#endif
#ifndef __LB_HANDLECHUNK__
#include "LB_HandleChunk.h"
#endif
#ifndef __CB_OBJECTMANAGER__
#include "CB_ObjectManager.h"
#endif
#ifndef __MM_MEMORYMANAGER__
#include "MM_MemoryManager.h"
#endif
#ifndef __EX_EXTERMINATOR__
#include "EX_Exterminator.h"
#endif

SN_Error TK_AttachLong(FT_TaggableObject& rObject, FT_TagName tagName, long tagData)
{	
	// Attach a long.
	return rObject.AttachDataTagWithValue(tagName, kLongTag, rObject.GetAllocatedTagData(sizeof(long)), (Ptr) &tagData);
}

SN_Error TK_RetrieveLong(FT_TaggableObject& rObject, FT_TagName tagName, long& rTagData)
{
	// Retrieve the tag and the tag data.
	FT_Tag*			pTag;
	return rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kLongTag, pTag, (Ptr) &rTagData);
}

long TK_RetrieveLong(FT_TaggableObject& rObject, FT_TagName tagName)
{
	long			result = 0;
	
	TK_RetrieveLong(rObject, tagName, result);
	
	return result;
}

SN_Error TK_AttachRectangle(FT_TaggableObject& rObject, FT_TagName tagName, Rect& rTagData)
{
	// Attach a rectangle.
	return rObject.AttachDataTagWithValue(tagName, kRectangleTag, rObject.GetAllocatedTagData(sizeof(Rect)), (Ptr) &rTagData);
}

SN_Error TK_AttachPoint(FT_TaggableObject& rObject, FT_TagName tagName, Point tagData)
{
	return rObject.AttachDataTagWithValue(tagName, kPointTag, rObject.GetAllocatedTagData(sizeof(Point)), (Ptr) &tagData);
}

SN_Error TK_RetrieveRectangle(FT_TaggableObject& rObject, FT_TagName tagName, Rect& rTagData)
{
	// Retrieve the tag and the tag data.
	FT_Tag*			pTag;
	return rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kRectangleTag, pTag, (Ptr) &rTagData);
}

SN_Error TK_RetrievePoint(FT_TaggableObject& rObject, FT_TagName tagName, Point& rTagData)
{
	// Retrieve the tag and the tag data.
	FT_Tag*			pTag;
	return rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kPointTag, pTag, (Ptr) &rTagData);
}

Rect TK_RetrieveRectangle(FT_TaggableObject& rObject, FT_TagName tagName)
{
	Rect			result;
	SetRect(&result, 0, 0, 0, 0);
	
	TK_RetrieveRectangle(rObject, tagName, result);
	
	return result;
} 

SN_Error TK_AttachReference(FT_TaggableObject& rObject, FT_TagName tagName, void* tagData)
{
	// Attach a reference.
	return rObject.AttachDataTagWithValue(tagName, kReferenceTag, rObject.GetAllocatedTagData(sizeof(Ptr)), (Ptr) &tagData);
}

SN_Error TK_RetrieveReference(FT_TaggableObject& rObject, FT_TagName tagName, void*& rpTagData)
{
	long			value = 0;
	SN_Error		result;
	
	result = TK_RetrieveLong(rObject, tagName, value);
	rpTagData = (void*) value;
	
	return result;
}

void* TK_RetrieveReference(FT_TaggableObject& rObject, FT_TagName tagName)
{
	void*			pResult = nil;
	
	TK_RetrieveReference(rObject, tagName, pResult);
	
	return pResult;
}

SN_Error TK_AttachRGBColor(FT_TaggableObject& rObject, FT_TagName tagName, RGBColor& rTagData)
{
	// Attach a RGBColor.
	return rObject.AttachDataTagWithValue(tagName, kRGBColorTag, rObject.GetAllocatedTagData(sizeof(RGBColor)), (Ptr) &rTagData);
}

SN_Error TK_RetrieveRGBColor(FT_TaggableObject& rObject, FT_TagName tagName, RGBColor& rTagData)
{		
	// Retrieve the tag and the tag data.
	FT_Tag*			pTag;
	return rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kRGBColorTag, pTag, (Ptr) &rTagData);
}

RGBColor TK_RetrieveRGBColor(FT_TaggableObject& rObject, FT_TagName tagName)
{
	RGBColor			result;
	
	result.red = 0;
	result.green = 0;
	result.blue = 0;
	
	TK_RetrieveRGBColor(rObject, tagName, result);
	
	return result;
}

SN_Error TK_AttachPascalString(FT_TaggableObject& rObject, FT_TagName tagName, Str255 tagData)
{
	return rObject.AttachDataTagWithValue(tagName, kPascalStringTag, rObject.GetAllocatedTagData(tagData[0] + 1),
										  (Ptr) tagData);
}

SN_Error TK_AttachShort(FT_TaggableObject& rObject, FT_TagName tagName, short tagData)
{
	return rObject.AttachDataTagWithValue(tagName, kShortTag, rObject.GetAllocatedTagData(sizeof(short)), (Ptr) &tagData);
}

SN_Error TK_AttachBoolean(FT_TaggableObject& rObject, FT_TagName tagName, Boolean tagData)
{
	return rObject.AttachDataTagWithValue(tagName, kBooleanTag, rObject.GetAllocatedTagData(sizeof(Boolean)), (Ptr) &tagData);
}

SN_Error TK_AttachCharacter(FT_TaggableObject& rObject, FT_TagName tagName, char tagData)
{
	return rObject.AttachDataTagWithValue(tagName, kCharacterTag, rObject.GetAllocatedTagData(sizeof(char)), (Ptr) &tagData);
}

SN_Error TK_AttachData(FT_TaggableObject& rObject, FT_TagName tagName, void* pTagData, FT_TagDataSize dataSize)
{
	return rObject.AttachDataTagWithValue(tagName, kDataTag, rObject.GetAllocatedTagData(dataSize), (Ptr) pTagData);
}

SN_Error TK_RetrievePascalString(FT_TaggableObject& rObject, FT_TagName tagName, StringPtr pTagData)
{
	// Retrieve the tag and the tag data.
	FT_Tag*			pTag;
	return rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kPascalStringTag, pTag, (Ptr) pTagData);
}

SN_Error TK_RetrieveShort(FT_TaggableObject& rObject, FT_TagName tagName, short& rTagData)
{
	// Retrieve the tag and the tag data.
	FT_Tag*			pTag;
	return rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kShortTag, pTag, (Ptr) &rTagData);
}

SN_Error TK_RetrieveBoolean(FT_TaggableObject& rObject, FT_TagName tagName, Boolean& rTagData)
{
	// Retrieve the tag and the tag data.
	FT_Tag*			pTag;
	return rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kBooleanTag, pTag, (Ptr) &rTagData);
}

SN_Error TK_RetrieveCharacter(FT_TaggableObject& rObject, FT_TagName tagName, char& rTagData)
{
	// Retrieve the tag and the tag data.
	FT_Tag*			pTag;
	return rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kCharacterTag, pTag, (Ptr) &rTagData);
}

SN_Error TK_RetrieveData(FT_TaggableObject& rObject, FT_TagName tagName, Handle& rhTagData)
{
	SN_Error			result;

	EX_TRY
	{
		rhTagData = nil;
	
		// Retrieve the tag and the tag data.
		FT_Tag*			pTag;
	
		EX_THROW_ERROR(rObject.RetrieveTag(tagName, pTag));
		EX_THROW_NIL(pTag);
		
		if (pTag->GetDataSize() > 0)
		{
			EX_THROW_ERROR(MM_AllocateRelocatableData(pTag->GetDataSize(), rhTagData));
			EX_THROW_NIL(rhTagData);
			EX_THROW_NIL(*rhTagData);
			
			MM_UseHandle			useHandle(rhTagData);
			rObject.RetrieveAndStuffTagNeedsDataAndType(tagName, kDataTag, pTag, *rhTagData);
		}
	}
	catch (SN_Exception& rException)
	{
		result = rException;
		
		MM_ReleaseRelocatableData(rhTagData);
	}
	
	return result;
}

SN_Error TK_AttachPackedStorableObject(FT_TaggableObject& rObject, TK_StorableObject& rStorableObject, FT_TagName tagName, FT_TagType tagType)
{
	TK_PackerObject			childObject;
	LB_HandleChunk		handleChunk(1);
	SN_Error			result;
	
	// Pack the child's data.
	if (rStorableObject.PackData(handleChunk).NoError())
	{			
		// Attach the packed child object to the view storage object as a tag.
		result = rObject.AttachTag(tagName, tagType, handleChunk.GetHandle(), GetHandleSize(handleChunk.GetHandle()));
	}
		
	// Don't delete the tag data.
	handleChunk.SetData(nil);
	
	return result;
}

SN_Error TK_RetrievePackedStorableObject(FT_TaggableObject& rObject, FT_TagName tagName, FT_TagData& rTagData)
{
	return rObject.RetrieveTagData(tagName, rTagData);
}

FT_TagType TK_GetPackedTagType(FT_TagData packedTag)
{
	FT_TagType			result = '????';

	if (packedTag)	
		if (*packedTag)
			result = ((TK_TagHeader*) *packedTag)->tkt_tagType;
			
	return result;
}

FT_TagName TK_GetPackedTagName(FT_TagData packedTag)
{
	FT_TagName			result = '????';
	
	if (packedTag)	
		if (*packedTag)
			result = ((TK_TagHeader*) *packedTag)->tkt_tagName;
			
	return result;
}

FT_TagDataSize TK_GetPackedTagDataSize(FT_TagData packedTag)
{
	FT_TagDataSize			result = 0;
	
	if (packedTag)	
		if (*packedTag)
			result = ((TK_TagHeader*) *packedTag)->tkt_tagDataSize;
	
	return result;
}
