/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __TK_STORABLEOBJECT__
#define __TK_STORABLEOBJECT__

#ifndef __LB_STORABLEOBJECT__
#include "LB_StorableObject.h"
#endif

/*
	TK_StorableObject for objects that use tags for storage and loading.
 */
 
class TK_PackerObject;
class TK_StorableObject:public LB_StorableObject
{
public:	// From LB_StorableObject.
	virtual SN_Error PackData(LB_DataChunk& rDataChunk);
	virtual SN_Error UnpackData(LB_DataChunk& rPackedData);

	virtual SN_Error UnpackData(Handle hData, Boolean destroyData = false);

public:
	virtual SN_Error AttachStorageTags(TK_PackerObject& rObject);
	virtual SN_Error ExtractStorageTags(TK_PackerObject& rObject);
};

#endif
