/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __TK_STORABLEOBJECT__
#include "TK_StorableObject.h"
#endif
#ifndef __TK_PACKEROBJECT__
#include "TK_PackerObject.h"
#endif
#ifndef __LB_HANDLECHUNK__
#include "LB_HandleChunk.h"
#endif
#ifndef __MM_MEMORYMANAGER__
#include "MM_MemoryManager.h"
#endif
#ifndef __EX_EXTERMINATOR__
#include "EX_Exterminator.h"
#endif

SN_Error TK_StorableObject::PackData(LB_DataChunk& rDataChunk)
{
	SN_Error			result;
	TK_PackerObject			tempObject;
	
	EX_TRY
	{
		EX_THROW_ERROR(AttachStorageTags(tempObject));
		EX_THROW_ERROR(tempObject.PackData(rDataChunk));
	}
	catch (SN_Exception& rException)
	{
		result = rException;
	}
	
	return result;	
}

SN_Error TK_StorableObject::UnpackData(LB_DataChunk& rPackedData)
{
	SN_Error			result;
	TK_PackerObject			tempObject;
	
	EX_TRY
	{
		EX_THROW_ERROR(tempObject.UnpackData(rPackedData));
		EX_THROW_ERROR(ExtractStorageTags(tempObject));
	}
	catch (SN_Exception& rException)
	{
		result = rException;
	}

	return result;
}

SN_Error TK_StorableObject::AttachStorageTags(TK_PackerObject& rObject)
{
	SN_Error			result;
	
	// Override this method and attach any tags for storage.
	
	return result;
}

SN_Error TK_StorableObject::ExtractStorageTags(TK_PackerObject& rObject)
{
	SN_Error			result;
	
	// Override this method and extract tags from a previously stored object.
	
	return result;
}

SN_Error TK_StorableObject::UnpackData(Handle hData, Boolean destroyData)
{
	MM_UseHandle			useHandle(hData);
	LB_HandleChunk			handleChunk(hData);
	SN_Error				result;
	
	result = UnpackData(handleChunk);
	
	if (!destroyData)
		// Don't destroy the Handle.
		handleChunk.SetData(nil);
		
	return result;
}
