/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */
 
#ifndef __TK_PACKEROBJECT__
#define __TK_PACKEROBJECT__

#ifndef __LB_STORABLEOBJECT__
#include "LB_StorableObject.h"
#endif
#ifndef __FT_TAGGABLEOBJECT__
#include "FT_TaggableObject.h"
#endif
#ifndef __TK_TAGHEADER__
#include "TK_TagHeader.h"
#endif

/*
	TK_PackerObject for objects can store/load their tags.
 */
 
class TK_PackerObject:public FT_TaggableObject,
				public LB_StorableObject
{
protected:
	virtual SN_Error KeepPackingData(LB_DataChunk& rDataChunk, long& rStuffOffset);
	virtual SN_Error Create();

public:	// From LB_StorableObject.
	virtual SN_Error PackData(LB_DataChunk& rDataChunk);
	virtual SN_Error UnpackData(LB_DataChunk& rPackedData);
	
public:
	TK_PackerObject();
	virtual ~TK_PackerObject();
	virtual SN_Error Dispose(Boolean destroy = true, Boolean stopOnError = false);
	
	// Combine all of the objects data and put it into one data chunk.
	virtual SN_Error PrepareForPackingData(LB_DataChunk& rDataChunk);
	virtual SN_Error PackMyData(LB_DataChunk& rDataChunk);
	virtual SN_Error FinishPackingData(LB_DataChunk& rDataChunk);
	virtual void FailPackingData(LB_DataChunk& rDataChunk);
	
	// Unpack the packed data to restore the object.
	virtual SN_Error PrepareForUnpackingData(LB_DataChunk& rPackedData);
	virtual SN_Error UnpackMyData(LB_DataChunk& rPackedData);
	virtual SN_Error FinishUnpackingData(LB_DataChunk& rPackedData);
	virtual void FailUnpackingData(LB_DataChunk& rPackedData);
	
	virtual Boolean IsTaggedData(LB_DataChunk& rPackedData);
	
	// Object storage routines.
	virtual SN_Error LoadObjectFromResource(ResType resourceType, short resourceID);
};

#endif
