/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __LB_DATACHUNK__
#define __LB_DATACHUNK__

#ifndef __LB_TYPES__
#include "LB_Types.h"
#endif
#ifndef __SN_ERROR__
#include "SN_Error.h"
#endif

/*
	LB_DataChunk for abstracting differences between pointers and handles.
 */
 
class LB_ChunkData;
class LB_DataChunk
{
protected:
	long				lbd_refCount;
	
	LB_DataReference	lbd_dataReference;
	
public:
	LB_DataChunk();
	virtual ~LB_DataChunk();
	
	virtual SN_Error UseData(LB_DataReference dataReference);
	
	// Every object chunk must resolve itself into chunk data.
	virtual SN_Error RetrieveData(LB_ChunkData& rChunkData) = 0;
	
	// Every data reference must be able to be released from memory.
	virtual SN_Error DestroyData() = 0;
	
	// Release the data from being referenced. 
	virtual SN_Error ReleaseData(LB_DataReference dataReference);

	// Data validation routines.
	virtual Boolean IsValidData(LB_DataReference dataReference) { return (lbd_dataReference != nil); };
	virtual Boolean HasValidData() { return IsValidData(GetData()); };

	// Data size routines. 
	virtual LB_DataSize GetDataSize() = 0;
	virtual LB_DataSize SetDataSize(LB_DataSize newSize) = 0;

	// Data extraction routines.
	virtual LB_DataSize ExtractData(Ptr pDestination, LB_DataSize extractOffset, LB_DataSize extractSize);

	// Data stuffing routines.
	virtual LB_DataSize StuffData(Ptr pData, LB_DataSize stuffOffset, LB_DataSize stuffSize);
	virtual LB_DataSize StuffAndOffsetData(Ptr pData, LB_DataSize& rStuffOffset, LB_DataSize stuffSize);
	virtual LB_DataSize StuffOffsetAndResizeData(Ptr pData, LB_DataSize& rStuffOffset, LB_DataSize stuffSize);
	
	// Dependancy routines.
	virtual Boolean MyDependancy(LB_DataReference dataReference);
	virtual SN_Error AddDependancy();
	virtual SN_Error RemoveDependancy();
	virtual SN_Error RemoveAllDependancies();
	
	// Accessors.
	virtual LB_DataReference GetDataReference() { return GetRealData(); };
	virtual LB_DataReference GetRealData() { return lbd_dataReference; };
	virtual LB_DataReference GetData() { return lbd_dataReference; };
	virtual long CountDependancies() { return lbd_refCount; };
	
	// Mutators.
	virtual void SetData(LB_DataReference dataReference) { this->lbd_dataReference = dataReference; };
};

#endif
