/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __FT_TAG__
#include "FT_Tag.h"
#endif
#ifndef __MM_MEMORYMANAGER__
#include "MM_MemoryManager.h"
#endif

FT_Tag::FT_Tag()
{
	SetData(nil, 0);
}

FT_Tag::~FT_Tag()
{
	Dispose(false, false);
}

SN_Error FT_Tag::Dispose(Boolean destroy, Boolean stopOnError)
{
	SN_Error			result;
	
	// Release the tag data from memory.
	if (HasData())
		MM_ReleaseRelocatableData(ftt_tagData);
		
	return result;
}

SN_Error FT_Tag::ResizeData(FT_TagDataSize tagDataSize)
{
	SN_Error			result;
	
	if (ftt_tagData == nil)
	{
		// Create a new handle for the data.
		MM_AllocateRelocatableData(tagDataSize, ftt_tagData);
		
		if (ftt_tagData)
		{
			HNoPurge(ftt_tagData);
			HUnlock(ftt_tagData);
		}
	}
	else
		// Resize the pointer to the tag data.
		SetHandleSize(ftt_tagData, tagDataSize);
		
	result.SetType(MemError());
	
	if (result.NoError())
		// The change of data size was successful.
		SetDataSize(tagDataSize);		
	
	return result;
}

Boolean FT_Tag::HasData()
{
	Boolean			result = false;
	
	if (GetData())
		if (*GetData())
			result = true;
			
	return result;
}

FT_TagData FT_Tag::GetData()
{
	return ftt_tagData;
}

FT_TagDataSize FT_Tag::GetDataSize()
{
	return GetDataSizeWithHeader(0);
}

FT_TagDataSize FT_Tag::GetDataSizeWithHeader(FT_TagDataSize headerSize)
{
	return ftt_tagDataSize + headerSize;
}

void FT_Tag::SetData(FT_TagData tagData, FT_TagDataSize tagDataSize)
{
	this->ftt_tagData = tagData;
	this->ftt_tagDataSize = tagDataSize;
}
