-----------------------------------TUIMisc.java---------------------------
package bmsi.tui;
import java.awt.*;
import java.awt.event.*;
import java.awt.peer.*;
import java.io.IOException;

// Miscellaneous simple peers -

class TUILabel extends TUIComponent implements LabelPeer {
  TUILabel(Label lab,TUIKit toolkit) { super(lab,toolkit); }
  protected void create(TUIContainer parent) {
    winID = toolkit.createRemotePeer(parent,NEWLABEL,this);
  }
  protected void initialize() {
    Label lab = (Label)target;
    String text = lab.getText();
    int a = lab.getAlignment();
    if (text != null)
      setText(text);
    if (a != 0)
      setAlignment(a);
    super.initialize();
  }
  public Dimension getMinimumSize() {
    Label lab = (Label)target;
    return toolkit.scale(new Dimension(lab.getText().length(),1));
  }
  public void setAlignment(int a) { toolkit.writeCmd(this,SETALIGNMENT,a); }
  public void setText(String s) { toolkit.writeCmd(this,SETTEXT,s); }
  public boolean isFocusTraversable() { return false; }
}

class TUICheckbox extends TUIComponent implements CheckboxPeer {
  TUICheckbox(Checkbox cb,TUIKit toolkit) { super(cb,toolkit); }
  protected void create(TUIContainer parent) {
    winID = toolkit.createRemotePeer(parent,NEWCHECKBOX,this);
  }
  protected void initialize() {
    Checkbox cb = (Checkbox)target;
    String text = cb.getLabel();
    if (text != null)
      setLabel(text);
    setState(cb.getState());
    super.initialize();
  }
  public void setLabel(String s) { toolkit.writeCmd(this,SETTEXT,s); }
  public void setState(boolean state) {
    toolkit.writeCmd(this,SETSTATE,state ? 1 : 0);
  }
  public void setCheckboxGroup(CheckboxGroup g) { }
  /** Handle checkbox state locally. */
  public void remoteMethod(int cmd) throws IOException {
    if (cmd == MENUPICK) {
      Checkbox cb = (Checkbox)target;
      boolean flag = !cb.getState();
      cb.setState(flag);
      toolkit.theQueue.postEvent(
	new ItemEvent(cb,ItemEvent.ITEM_STATE_CHANGED,cb.getLabel(),
	flag ? ItemEvent.SELECTED : ItemEvent.DESELECTED)
      );
      return;
    }
    super.remoteMethod(cmd);
  }
  public Dimension getMinimumSize() {
    Checkbox cb = (Checkbox)target;
    return toolkit.scale(new Dimension(cb.getLabel().length() + 4,1));
  }
}

class TUIButton extends TUIComponent implements ButtonPeer {
  TUIButton(Button but,TUIKit toolkit) { super(but,toolkit); }
  protected void create(TUIContainer parent) {
    winID = toolkit.createRemotePeer(parent,NEWBUTTON,this);
  }
  public Dimension getMinimumSize() {
    Button but = (Button)target;
    return toolkit.scale(new Dimension(but.getLabel().length(),1));
  }
  protected void initialize() {
    Button but = (Button)target;
    String text = but.getLabel();
    if (text != null)
      setLabel(text);
    super.initialize();
  }
  public void setLabel(String s) { toolkit.writeCmd(this,SETTEXT,s); }
  public void remoteMethod(int cmd) throws IOException {
    if (cmd == MENUPICK) {
      Button but = (Button)target;
      toolkit.theQueue.postEvent(
	new ActionEvent(but,ActionEvent.ACTION_PERFORMED,but.getActionCommand())
      );
      return;
    }
    super.remoteMethod(cmd);
  }
}

class TUICanvas extends TUIComponent implements CanvasPeer {
  TUICanvas(Canvas c,TUIKit toolkit) { super(c,toolkit); }
  protected void create(TUIContainer parent) {
    winID = toolkit.createRemotePeer(parent,NEWCANVAS,this);
  }
  /** Add rectangle to list of areas to be repainted in ms time.
   * Most TUIComponents are painted entirely by the remote program.
   * A Canvas is painted by the application and we must therefore
   * invoke the application.
   */
  public void repaint(long ms,int x,int y,int w,int h) {
    Graphics g = getGraphics();
    g.clipRect(x,y,w,h);
    target.update(g);
    g.dispose();
  }
}

class TUIScrollbar extends TUIComponent implements ScrollbarPeer {
  private int pageinc, lineinc, value;
  private boolean vertical;
  TUIScrollbar(Scrollbar sb,TUIKit toolkit) { super(sb,toolkit); }
  protected void create(TUIContainer parent) {
    Scrollbar sb = (Scrollbar)target;
    vertical = sb.getOrientation() == Scrollbar.VERTICAL;
    if (vertical)
      winID = toolkit.createRemotePeer(parent,NEWVERTSCROLL,this);
    else
      winID = toolkit.createRemotePeer(parent,NEWHORZSCROLL,this);
  }

  protected void initialize() {
    Scrollbar sb = (Scrollbar)target;
    setValues(sb.getValue(),sb.getVisibleAmount(),
		sb.getMinimum(),sb.getMaximum());
    setPageIncrement(sb.getBlockIncrement());
    setLineIncrement(sb.getUnitIncrement());
  }

  public void setValues(int val,int vis,int min,int max) {
    value = val;
    toolkit.writeCmd(this,SETVALUES,val,vis,min,max);
  }

  public void setValue(int val) {
    value = val;
    toolkit.writeCmd(this,SETVALUE,val);
  }

  public void setLineIncrement(int i) {
    lineinc = i;
  }

  public void setPageIncrement(int i) {
    pageinc = i;
  }

  /* TUI scrollbars are always 1 char wide (high) */
  public Dimension getMinimumSize() {
    Dimension sz = target.getSize();
    Dimension scale = toolkit.scale(new Dimension(1,1));
    if (vertical)
      sz.width = scale.width;
    else
      sz.height = scale.height;
    return sz;
  }

  private void notifyValue(int type,int change) {
    Scrollbar sb = (Scrollbar)target;
    sb.setValue(sb.getValue() + change);
    toolkit.theQueue.postEvent(new AdjustmentEvent(sb,
      AdjustmentEvent.ADJUSTMENT_VALUE_CHANGED,type,value));
  }
 
  public void remoteMethod(int cmd) throws IOException {
    switch (cmd) {
    case SCROLL_LINEDEC:
      notifyValue(AdjustmentEvent.UNIT_DECREMENT,value-lineinc);
      return;
    case SCROLL_LINEINC:
      notifyValue(AdjustmentEvent.UNIT_INCREMENT,value+lineinc);
      return;
    case SCROLL_PAGEDEC:
      notifyValue(AdjustmentEvent.BLOCK_DECREMENT,value-pageinc);
      return;
    case SCROLL_PAGEINC:
      notifyValue(AdjustmentEvent.BLOCK_INCREMENT,value+pageinc);
      return;
    case SETVALUE:
      notifyValue(AdjustmentEvent.TRACK,toolkit.readShort());
      return;
    }
    super.remoteMethod(cmd);
  }
}




