package bmsi.tui;

import java.awt.*;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;

/** This FileDialog was adapted from sun.awt.tiny.FileDialog.  
 We changed the hardwired insets and sizes.  It still needs more work.
 The layout is OK (fortunately, since I hate GridBagLayout), but
 the behaviour of the fields seems confusing to me.

 The FileDialog for a remote peer need to browse files on the server
 since that is where the java code is running.  A Java Thin Client would
 still use this FileDialog, not the one for the workstation.
 */

class TUIFileDialog extends Dialog implements FileDialogPeer {
  FileDialog target;
  String file;
  String dir;
  String title;
  int mode;
  FilenameFilter filter;
  GridBagLayout gbl;
  FlowLayout gblButtons;
  GridBagConstraints gbc;
  TextField filterField;
  TextField selectionField;
  List directoryList;
  List fileList;
  Panel buttons;
  Button openButton;
  Button filterButton;
  Button cancelButton;

  public TUIFileDialog(FileDialog fileDialog) {
    super((Frame)fileDialog.getParent(), fileDialog.getTitle(), true);
    target = fileDialog;
    title = fileDialog.getTitle();
    mode = fileDialog.getMode();
    target = fileDialog;
    gbl = new GridBagLayout();
    gblButtons = new FlowLayout(FlowLayout.CENTER,1,1);
    gbc = new GridBagConstraints();
    setLayout(gbl);
    buttons = new Panel();
    buttons.setLayout(gblButtons);
    openButton = new Button("Open");
    filterButton = new Button("Filter");
    cancelButton = new Button("Cancel");
    directoryList = new List(8);
    fileList = new List(8);
    filterField = new TextField("*",14);
    selectionField = new TextField("",14);
    Insets insets2 = new Insets(0, 2, 0, 2);
    Insets insets3 = new Insets(0, 2, 0, 1);
    Insets insets4 = new Insets(0, 1, 0, 2);
    Insets insets5 = new Insets(2, 0, 0, 0);
    Insets insets6 = new Insets(0, 2, 0, 0);
    Insets insets7 = new Insets(2, 2, 2, 2);
    Label label = new Label("Filter");
    addComponent(label, gbl, gbc, 0, 0, 1, 17, this, 1, 0, 0, insets6);
    addComponent(filterField, gbl, gbc, 0, 1, 2, 17, this, 1, 0, 2, insets2);
    label = new Label("Directories");
    addComponent(label, gbl, gbc, 0, 2, 1, 17, this, 1, 0, 0, insets6);
    label = new Label("Files");
    addComponent(label, gbl, gbc, 1, 2, 1, 17, this, 1, 0, 0, insets6);
    addComponent(directoryList, gbl, gbc, 0, 3, 1, 17, this, 1, 1, 1, insets3);
    addComponent(fileList, gbl, gbc, 1, 3, 1, 17, this, 1, 1, 1, insets4);
    label = new Label("Selection");
    addComponent(label, gbl, gbc, 0, 4, 1, 17, this, 1, 0, 0, insets6);
    addComponent(selectionField, gbl, gbc, 0, 5, 2, 17, this, 1, 0, 2, insets2);
    buttons.add(openButton);
    buttons.add(filterButton);
    buttons.add(cancelButton);
    addComponent(buttons, gbl, gbc, 0, 7, 2, 17, this, 1, 0, 2, insets7);
    pack();
    String string = fileDialog.getDirectory();
    if (string != null) {
      setDirectory(string);
      return;
    }
    if ((string = fileDialog.getFile()) != null)
      setFile(string);
  }

  void addComponent(Component component, GridBagLayout gridBagLayout,
    GridBagConstraints gridBagConstraints, int i1, int j1, int k1, int i2,
    Container container, int j2, int k2, int i3, Insets insets) {
      gridBagConstraints.gridx = i1;
      gridBagConstraints.gridy = j1;
      gridBagConstraints.gridwidth = k1;
      gridBagConstraints.anchor = i2;
      gridBagConstraints.weightx = j2;
      gridBagConstraints.weighty = k2;
      gridBagConstraints.fill = i3;
      gridBagConstraints.insets = insets;
      gridBagLayout.setConstraints(component, gridBagConstraints);
      container.add(component);
  }

  static String getFileName(String string) {
    return (new File(string)).getName();
  }
  static String getParent(String string) {
    return (new File(string)).getParent();
  }

  void handleFilter(String filename) {
    String dirname;
    if (filename == null)
      return;
    int i = filename.lastIndexOf(File.separatorChar);
    if (i == -1)
      dirname = "./";
    else {
      dirname = filename.substring(0, i + 1);
      filename = filename.substring(i + 1);
    }
    setFilterEntry(dirname, filename);
  }

  void handleSelection(String name) {
    String dirname;
    int i = name.lastIndexOf(File.separatorChar);
    if (i == -1)
      target.setFile(name);
    else
      target.setFile(name.substring(i + 1));
    target.setDirectory(dir);
  }

  void handleCancel() {
    setSelectionField(null);
    setFilterField(null);
    directoryList.clear();
    fileList.clear();
    target.setFile(null);
    target.setDirectory(null);
  }

  void handleQuit() {
    handleCancel();
    target.hide();
  }

  void setFilterEntry(String dirname, String filename) {
    File file1 = new File(dirname);
    if (file1.isDirectory() && file1.canRead()) {
      String astring[];
      setSelectionField(dirname);
      if (filename.equals(""))
	filename = "*";
      setFilterField(dirname + filename);
      if (filename.equals("*"))
	astring = file1.list();
      else
	astring = file1.list(new FileDialogFilter(filename));
      jgl.Sorting.sort(new jgl.ObjectArray(astring),new jgl.LessString());
      directoryList.clear();
      fileList.clear();
      directoryList.addItem("<Parent Directory>");
      for (int i = 0; i < astring.length; i++) {
	File file2 = new File(dirname + astring[i]);
	if (file2.isDirectory())
	  directoryList.addItem(astring[i] + "/");
	else
	  fileList.addItem(astring[i]);
      }
      dir = dirname;
      target.setDirectory(dir);
    }
  }

  void setSelectionField(String string) {
    selectionField.setText(string);
  }

  void setFilterField(String string) {
    filterField.setText(string);
  }

  public boolean handleEvent(Event event) {
    switch (event.id) {
    case Event.LIST_SELECT:
      if (directoryList == event.target) {
	int i = ((Integer)event.arg).intValue();
	if (i > 0)
	  handleFilter(dir + directoryList.getItem(i)
	    + getFileName(filterField.getText()));
	else
	  handleFilter(getParent(dir) + getFileName(filterField.getText()));
	return true;
      }
      if (fileList != event.target)
	return false;
      int j = ((Integer)event.arg).intValue();
      setSelectionField(fileList.getItem(j));
      return true;
    case Event.LIST_DESELECT:
      if (directoryList == event.target) {
	setFilterField(dir + getFileName(filterField.getText()));
	return true;
      }
      if (fileList == event.target) {
	setSelectionField(dir);
	return true;
      }
    case Event.ACTION_EVENT:
      if (event.arg.equals("Open")) {
	handleSelection(selectionField.getText());
	target.hide();
	return true;
      }
      if (event.arg.equals("Filter")) {
	handleFilter(filterField.getText());
	return true;
      }
      if (event.arg.equals("Cancel")) {
	handleQuit();
	return true;
      }
      if (event.target instanceof TextField) {
	if (selectionField == event.target) {
	  handleSelection(selectionField.getText());
	  target.hide();
	  return true;
	}
	if (filterField != event.target)
	  return false;
	handleFilter(filterField.getText());
	return true;
      }
      if (event.target instanceof List) {
	if (directoryList == event.target) {
	  handleFilter((String)event.arg
	    + getFileName(filterField.getText()));
	  return true;
	}
	if (fileList != (List)event.target)
	  return false;
	handleSelection((String)event.arg);
	target.hide();
	return true;
      }
    }
    return false;
  }

  public void handleEvent(AWTEvent aWTEvent) { }

  public void setFile(String string1) {
    if (string1 == null) {
      file = null;
      return;
    }
    if (dir == null) {
      String string2 = "./";
      File file2 = new File(string2, string1);
      if (file2.isFile()) {
	  file = string1;
	  setDirectory(string2);
	  return;
      }
    }
    else {
      File file1 = new File(dir, string1);
      if (file1.isFile())
	  file = string1;
    }
  }

  public void setDirectory(String string) {
    if (string == null) {
      dir = null;
      return;
    }
    if (string.equals(dir))
      return;
    File file = new File(string);
    if (!file.isDirectory()) {
      string = "./";
      file = new File(string);
      if (!file.isDirectory())
	return;
    }
    if (string.endsWith("/")) {
      handleFilter(string);
      return;
    }
    handleFilter(string + '/');
  }

  public void setFilenameFilter(FilenameFilter filenameFilter) {
    filter = filenameFilter;
  }

  public boolean isFocusTraversable() {
    return false;
  }

  public void beginValidate() { }
  public void endValidate() { }
}
