#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <vbapi.h>
#include "CtrlProp.h"
#include "CtrlInfo.h"


HWND GetWindowUnderMouse(HWND hwndCapture, POINT ptMouse);


extern "C"
{
BOOL FAR PASCAL _export ControlDlgProc(HWND hDlg, USHORT msg, USHORT wp, LONG lp);
BOOL FAR PASCAL _export PropertyDlgProc(HWND hDlg, USHORT msg, USHORT wp, LONG lp);
}                        

HANDLE hmodDLL;


static HWND CreateButton   (char *caption, HWND hwndParent, int ChildID);
static void PositionChildControls (HWND hwnd, LPCTRLINFO lpCtrlInfo);

LONG FAR PASCAL _export CtrlInfoCtlProc
(
    HCTL   hctl,
    HWND   hwnd,
    USHORT msg,
    USHORT wp,
    LONG   lp
)
{
   LPCTRLINFO lpCtrlInfo = LpCtrlInfoDEREF(hctl);
   switch (msg)
   {
      case VBM_CREATED:
         lpCtrlInfo->hwndButton = CreateButton("Ctrl Info", hwnd, ID_Button);
         PositionChildControls(hwnd, lpCtrlInfo);
         break;
     
      case WM_SIZE:
         PositionChildControls(hwnd, lpCtrlInfo);
         break;
  
      case WM_COMMAND:
         switch (wp)
         {
            case ID_Button:
               DialogBox(hmodDLL, MAKEINTRESOURCE(IDD_CTRL_DLG), HWND_DESKTOP, 
                  (DLGPROC)MakeProcInstance((FARPROC)ControlDlgProc, hmodDLL));
               break;
         }
         break;
   }

   return VBDefControlProc(hctl, hwnd, msg, wp, lp);
}


//---------------------------------------------------------------------------
// Initialize library. This routine is called when the first client loads
// the DLL.
//---------------------------------------------------------------------------
int FAR PASCAL LibMain
(
    HANDLE hModule,
    WORD   /*wDataSeg*/,
    WORD   /*cbHeapSize*/,
    LPSTR  /*lpszCmdLine*/
)
{
    hmodDLL = hModule;

    return 1;
}


//---------------------------------------------------------------------------
// Register custom control. This routine is called by VB when the custom
// control DLL is loaded for use.
//---------------------------------------------------------------------------
BOOL FAR PASCAL _export VBINITCC
(
    USHORT /*usVersion*/,
    BOOL   /*fRuntime*/
)
{
    // Register control(s)
    return VBRegisterModel(hmodDLL, &modelCtrlInfo);
}


//---------------------------------------------------------------------------
//WEP
//---------------------------------------------------------------------------
// C7 and QCWIN provide default a WEP:
//---------------------------------------------------------------------------

#ifdef COMMENT_OUT
#if (_MSC_VER < 610)

int FAR PASCAL WEP(int fSystemExit);

//---------------------------------------------------------------------------
// For Windows 3.0 it is recommended that the WEP function reside in a
// FIXED code segment and be exported as RESIDENTNAME.  This is
// accomplished using the alloc_text pragma below and the related EXPORTS
// and SEGMENTS directives in the .DEF file.
//
// Read the comments section documenting the WEP function in the Windows
// 3.1 SDK "Programmers Reference, Volume 2: Functions" before placing
// any additional code in the WEP routine for a Windows 3.0 DLL.
//---------------------------------------------------------------------------
#pragma alloc_text(WEP_TEXT,WEP)

//---------------------------------------------------------------------------
// Performs cleanup tasks when the DLL is unloaded.  WEP() is
// called automatically by Windows when the DLL is unloaded (no
// remaining tasks still have the DLL loaded).	It is strongly
// recommended that a DLL have a WEP() function, even if it does
// nothing but returns success (1), as in this example.
//---------------------------------------------------------------------------
int FAR PASCAL WEP
(
    int /*fSystemExit*/
)
{
    return 1;
}
#endif // C6
#endif // COMMENT_OUT

static HWND CreateButton (char *caption, HWND hwndParent, int ChildID)
{
  HWND hwnd = CreateWindow(
             /* class    */   "button", 
             /* caption  */   caption, 			 
             /* style    */   WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
             /* x        */   0, 
             /* y        */   0, 
             /* cx       */   0, 
             /* cy       */   0,
             /* parent   */   hwndParent, 
             /* id       */   ChildID, 
             /* instance */   hmodDLL, 
             /* params   */   NULL);
   return hwnd;
}

static void PositionChildControls (HWND hwnd, LPCTRLINFO lpCtrlInfo)
{
   RECT rect;
   
   GetWindowRect(hwnd, &rect);
   int DX = rect.right - rect.left;     // width  of control
   int DY = rect.bottom - rect.top;     // height of control
   
   SetWindowPos(lpCtrlInfo->hwndButton,    0, 0, 0,DX, DY, SWP_NOZORDER);
}

HWND GetWindowUnderMouse (HWND hwndCapture, POINT ptMouse)
{  
   HWND hwnd, hwndChild;
   ClientToScreen(hwndCapture, &ptMouse);
   hwnd = WindowFromPoint(ptMouse);
   
   // see if child of hwnd really is under mouse
   ScreenToClient(hwnd, &ptMouse);
   hwndChild = ChildWindowFromPoint(hwnd, ptMouse);
   ClientToScreen(hwnd, &ptMouse);
   if (hwndChild != 0)
      hwnd = hwndChild;
    
   return hwnd;
}

HCTL GetHCTL (HWND hwnd)
{
   HCTL hctl;

   while (hwnd)
   {
      hctl = VBGetHwndControl(hwnd);
      if (hctl)
         return hctl;
      hwnd = GetParent(hwnd);
   }
   return NULL;
}

void FillDlgFields (HWND hdlg, HWND hwnd);

struct
{
   HCTL hctl;
   short iProp;
} CurrentProperty; 

BOOL FAR PASCAL _export ControlDlgProc
(
   HWND   hDlg,
   USHORT msg,
   USHORT wp,
   LONG   lp
)
{
   HWND hwnd;
   static HWND hwndUnderMouse = 0;
   LPPROPINFO lpPropInfo;
   
   switch (msg)
   {
      case WM_INITDIALOG:
         FillDlgFields(hDlg, 0);
         return TRUE;
         
      case WM_MOUSEMOVE:
         if (GetCapture() == hDlg)
         {
            hwnd = GetWindowUnderMouse(hDlg, MAKEPOINT(lp));
            if (hwnd == hwndUnderMouse)
               break;  // dialog fields are already current
            hwndUnderMouse = hwnd;
            FillDlgFields(hDlg, hwndUnderMouse);
         }
         break;

      case WM_LBUTTONDOWN:
      case WM_LBUTTONDBLCLK:
         if (GetCapture() == hDlg)
         {
            SetWindowPos(hDlg, HWND_TOP, 0,0,0,0,SWP_NOSIZE|SWP_NOMOVE);
            ReleaseCapture();
            return 0;
         }
         break;

      case WM_COMMAND:
         switch (wp)
         {
            case IDD_PROPERTIES:
               if (HIWORD(lp) == LBN_DBLCLK)
               {
                  CurrentProperty.iProp = (short) 
                     SendDlgItemMessage(hDlg, IDD_PROPERTIES, LB_GETCURSEL, 0, 0);

                  lpPropInfo = GetProperty(
                     GetPropertyArray(CurrentProperty.hctl), 
                     CurrentProperty.iProp);
                  if (IsStandardProperty(lpPropInfo))
                    DialogBox(hmodDLL, MAKEINTRESOURCE(IDD_STANDARD_DLG), HWND_DESKTOP, 
                      (DLGPROC)MakeProcInstance((FARPROC)PropertyDlgProc, hmodDLL));
                  else
                    DialogBox(hmodDLL, MAKEINTRESOURCE(IDD_CUSTOM_DLG), HWND_DESKTOP, 
                      (DLGPROC)MakeProcInstance((FARPROC)PropertyDlgProc, hmodDLL));
               }
               break;
                  
            case IDD_SPY:
               SetCapture(hDlg);
               break;

            case IDD_HIDE:
               SetWindowPos(hDlg, HWND_BOTTOM, 0,0,0,0,SWP_NOSIZE|SWP_NOMOVE);
               SetCapture(hDlg);
               break;

            case IDCANCEL:
               EndDialog(hDlg, 0);
               return TRUE;
         }
         break;
   }
   return FALSE;
}


LPSTR PrintAddress (LPSTR buf, ULONG addr)
{
   wsprintf(buf, "%04X:%04X", (USHORT)HIWORD(addr), (USHORT)LOWORD(addr));
   return buf;
}

#define ADD_LIST_ENTRY(hDlg, id, lpsz) \
   SendDlgItemMessage(hDlg, id, LB_INSERTSTRING, -1, (LONG)(LPSTR)(lpsz))

void FillDlgFields (HWND hDlg, HWND hwnd)
{
   char buf[10];
   MODEL FAR *lpModel = NULL;
   HCTL hctl = 0;
   LPSTR lpsz;
   PPROPINFO FAR * PropertyArray;
   LPPROPINFO lpPropInfo;
   short i;
        
   hctl = GetHCTL(hwnd);
   
   SendDlgItemMessage(hDlg, IDD_FLAGS, LB_RESETCONTENT, 0, 0);
   SendDlgItemMessage(hDlg, IDD_PROPERTIES, LB_RESETCONTENT, 0, 0);        

   wsprintf(buf, "%04lX", (ULONG)hwnd);                        
   SetDlgItemText(hDlg, IDD_HWND, buf);                        

   CurrentProperty.hctl = hctl;
           
   if (hctl)
   {
      lpModel = VBGetControlModel(hctl);
      hwnd = VBGetControlHwnd(hctl);
   }   
   if (lpModel)
   {
      PrintAddress(buf, (ULONG)hctl);
      SetDlgItemText(hDlg, IDD_HCTL, buf);                        
                              
      lpsz = (LPSTR)MAKELONG(lpModel->npszClassName, (_segment)lpModel);
      SetDlgItemText(hDlg, IDD_CLASS,lpsz);

      lpsz = (LPSTR)MAKELONG(lpModel->npszParentClassName, (_segment)lpModel);
      SetDlgItemText(hDlg, IDD_PARENTCLASS,lpsz);

      wsprintf(buf, "%d", lpModel->cbCtlExtra);                        
      SetDlgItemText(hDlg, IDD_EXTRABYTES, buf);                        

      PrintAddress(buf, (ULONG)lpModel->pctlproc);
      SetDlgItemText(hDlg, IDD_PROCEDURE, buf);                        

      wsprintf(buf, "%X", lpModel->usCtlVersion);                        
      SetDlgItemText(hDlg, IDD_VERSION, buf);                        

      wsprintf(buf, "%X", lpModel->usVersion);                        
      SetDlgItemText(hDlg, IDD_VBVERSION, buf);

      #define SHOW_FLAG(val,desc) \
         if (lpModel->fl & val) \
            ADD_LIST_ENTRY(hDlg, IDD_FLAGS, desc)

      SHOW_FLAG(MODEL_fArrows,      "MODEL_fArrows");
      SHOW_FLAG(MODEL_fFocusOk,     "MODEL_fFocusOk");
      SHOW_FLAG(MODEL_fMnemonic,    "MODEL_fMnemonic");
      SHOW_FLAG(MODEL_fChildrenOk,  "MODEL_fChildrenOk");
      SHOW_FLAG(MODEL_fInitMsg,     "MODEL_fInitMsg");
      SHOW_FLAG(MODEL_fLoadMsg,     "MODEL_fLoadMsg");
      SHOW_FLAG(MODEL_fDesInteract, "MODEL_fDesInteract");
      SHOW_FLAG(MODEL_fInvisAtRun,  "MODEL_fInvisAtRun");
      SHOW_FLAG(MODEL_fGraphical,   "MODEL_fGraphical");
      #undef SHOW_FLAG

      PropertyArray = GetPropertyArray(hctl);
      for (i = 0; ; i++)
      {
         lpPropInfo = GetProperty(PropertyArray, i);
         if (!lpPropInfo)
            break;  // have reached end of PropertyArray
         lpsz = (LPSTR)MAKELONG(lpPropInfo->npszName, (_segment)lpPropInfo);
         ADD_LIST_ENTRY(hDlg, IDD_PROPERTIES, lpsz);        
      }
   }
   else
   {
      SetDlgItemText(hDlg, IDD_HCTL,       "00000000");                        
      SetDlgItemText(hDlg, IDD_CLASS,      "(none)");
      SetDlgItemText(hDlg, IDD_PARENTCLASS,"(none)");
      SetDlgItemText(hDlg, IDD_EXTRABYTES, "0000");                        
      SetDlgItemText(hDlg, IDD_PROCEDURE,  "00000000");                        
      SetDlgItemText(hDlg, IDD_VERSION,    "000");                        
      SetDlgItemText(hDlg, IDD_VBVERSION,  "000");                        
   }
}

BOOL FAR PASCAL _export PropertyDlgProc
(
   HWND   hDlg,
   USHORT msg,
   USHORT wp,
   LONG   /*lp*/
)
{
   ULONG DataType = 0;
   LPSTR lpsz;
   static char buf[64];
   PPROPINFO FAR* PropertyArray;
   LPPROPINFO lpPropInfo;
   
   switch (msg)
   {
      case WM_INITDIALOG:
         PropertyArray = GetPropertyArray(CurrentProperty.hctl);
         lpPropInfo = GetProperty(PropertyArray, CurrentProperty.iProp);

         lpsz = (LPSTR)MAKELONG(lpPropInfo->npszName, (_segment)lpPropInfo);
         if (!lstrcmp(lpsz, "UNKNOWN_STD"))
         {  
            wsprintf(buf, "IPROP_STD: %04X",
               ~((USHORT) PropertyArray[CurrentProperty.iProp]));
            lpsz = buf;
         }
         SetDlgItemText(hDlg, IDD_NAME, lpsz);
            
         PrintAddress(buf, (ULONG)lpPropInfo);
         SetDlgItemText(hDlg, IDD_ADDRESS, buf);
            
         #define SHOW_FLAG(val,desc) \
            if (lpPropInfo->fl & val) \
               ADD_LIST_ENTRY(hDlg, IDD_PROP_FLAGS, desc)

         SHOW_FLAG(PF_fPropArray,     "PF_fPropArray");
         SHOW_FLAG(PF_fSetData,       "PF_fSetData");
         SHOW_FLAG(PF_fSetMsg,        "PF_fSetMsg");
         SHOW_FLAG(PF_fNoShow,        "PF_fNoShow");
         SHOW_FLAG(PF_fNoRuntimeW,    "PF_fNoRuntimeW");
         SHOW_FLAG(PF_fGetData,       "PF_fGetData");
         SHOW_FLAG(PF_fGetMsg,        "PF_fGetMsg");
         SHOW_FLAG(PF_fSetCheck,      "PF_fSetCheck");
         SHOW_FLAG(PF_fSaveData,      "PF_fSaveData");
         SHOW_FLAG(PF_fSaveMsg,       "PF_fSaveMsg");
         SHOW_FLAG(PF_fLoadDataOnly,  "PF_fLoadDataOnly");
         SHOW_FLAG(PF_fLoadMsgOnly,   "PF_fLoadMsgOnly");
         SHOW_FLAG(PF_fGetHszMsg,     "PF_fGetHszMsg");
         SHOW_FLAG(PF_fUpdateOnEdit,  "PF_fUpdateOnEdit");
         SHOW_FLAG(PF_fEditable,      "PF_fEditable");
         SHOW_FLAG(PF_fPreHwnd,       "PF_fPreHwnd");
         SHOW_FLAG(PF_fDefVal,        "PF_fDefVal");
         SHOW_FLAG(PF_fNoInitDef,     "PF_fNoInitDef");
         SHOW_FLAG(PF_fNoRuntimeR,    "PF_fNoRuntimeR");
         SHOW_FLAG(PF_fNoMultiSelect, "PF_fNoMultiSelect");
         #undef SHOW_FLAG
         DataType = lpPropInfo->fl & PF_datatype;
         wsprintf(buf, "%02lXh (UNKNOWN)", (ULONG)DataType);
         lpsz = buf;
         switch (DataType)
         {
            case DT_BOOL:    lpsz = "DT_BOOL";    break;
            case DT_COLOR:   lpsz = "DT_COLOR";   break;
            case DT_ENUM:    lpsz = "DT_ENUM";    break;
            case DT_HLSTR:   lpsz = "DT_HLSTR";   break;
            case DT_HSZ:     lpsz = "DT_HSZ";     break;
            case DT_LONG:    lpsz = "DT_LONG";    break;
            case DT_PICTURE: lpsz = "DT_PICTURE"; break;
            case DT_OBJECT:  lpsz = "DT_OBJECT";  break;
            case DT_REAL:    lpsz = "DT_REAL";    break;
            case DT_SHORT:   lpsz = "DT_SHORT";   break;
            case DT_XPOS:    lpsz = "DT_XPOS";    break;
            case DT_XSIZE:   lpsz = "DT_XSIZE";   break;
            case DT_YPOS:    lpsz = "DT_YPOS";    break;
            case DT_YSIZE:   lpsz = "DT_YSIZE";   break;
         }
         SetDlgItemText(hDlg, IDD_DATATYPE, lpsz);
            
         wsprintf(buf, "-");
         lpsz = buf;

         union
         {
            HSZ hsz;
            HLSTR hlstr;
            short iShort;
            long iLong;
            float iReal;
            unsigned char uChar;
         } DataVal;


         VBGetControlProperty(CurrentProperty.hctl, CurrentProperty.iProp,
            &DataVal);
         switch (DataType)
         {
            case DT_BOOL:
               lpsz = DataVal.iShort == -1 ? "TRUE" : "FALSE";
               break;
            case DT_COLOR:
               wsprintf(buf, "%06X", DataVal.iLong);
               break;
            case DT_HLSTR:
               lpsz = VBDerefZeroTermHlstr(DataVal.hlstr);
               break;
            case DT_HSZ:
               lpsz = VBDerefHsz(DataVal.hsz);
               break;
            case DT_LONG:
               wsprintf(buf, "%ld (%lXh)", DataVal.iLong, DataVal.iLong);
               break;
            case DT_XPOS:
            case DT_XSIZE:
            case DT_YPOS:
            case DT_YSIZE:
               sprintf(buf, "%.0f", DataVal.iReal);
               break;
            case DT_REAL:
               sprintf(buf, "%f", DataVal.iReal);
               break;
            case DT_ENUM:
               wsprintf(buf, "%d", (short)DataVal.uChar);
               break;
            case DT_SHORT:
               wsprintf(buf, "%d (%Xh)", DataVal.iShort, DataVal.iShort);
               break;
         }

         if (lpsz)
            SetDlgItemText(hDlg, IDD_VALUE, lpsz);
         else
            SetDlgItemText(hDlg, IDD_VALUE, "NULL DATA");

         if (DataType == DT_HLSTR)
            if (DataVal.hlstr)
               VBDestroyHlstr(DataVal.hlstr);
         if (DataType == DT_HSZ)
            if (DataVal.hsz)
               VBDestroyHsz(DataVal.hsz);
      
         return TRUE;
         
      case WM_COMMAND:
         switch (wp)
         {
            case IDOK:
               EndDialog(hDlg, 0);
               return TRUE;
         }
         break;
   }
   return FALSE;
}
