

/*
 *
 *	Copyright (c) 1995-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


#if defined(_MSC_VER)
#if !defined(WIN32)  &&  _MSC_VER >= 900
#define	WIN32
#endif
#endif


#include <stdio.h>
#include <windows.h>
#include <mmsystem.h>


#define	CONTEXT_SWITCHES_PER_SECOND	50



 /*  thousands of a second  */
 
#define	TARGET_MILLSECS	(1000/CONTEXT_SWITCHES_PER_SECOND) 



#ifdef TEST
int	_tick_count=10000;
#else
extern	int	_tick_count;
#endif

static	UINT		wTimerRes;
static	UINT		id;

static	void	CALLBACK
timerfun(UINT	idEvent,
	 UINT	uReserved,
	 DWORD	dwUser,
	 DWORD	rwReserved1,
	 DWORD	rwReserved2)
{
	if (_tick_count)
		_tick_count--;
}

static	void	_end_timer(void)
{
	timeKillEvent(id);
	timeEndPeriod(wTimerRes);
}

void	_start_timer()
{
	TIMECAPS	tc;

	timeGetDevCaps(&tc, sizeof(TIMECAPS));
	wTimerRes = min(max(tc.wPeriodMin, TARGET_MILLSECS), tc.wPeriodMax);
	timeBeginPeriod(wTimerRes);
	id = timeSetEvent(wTimerRes, wTimerRes, (LPTIMECALLBACK) timerfun, (DWORD) 0, TIME_PERIODIC);
	atexit(_end_timer);
}

#ifdef TEST

main()
{
	int	n;
	long	i;

	_start_timer();

	for (n=0 ; n++ != 10 ; )  {
		fprintf(stderr, "Timer = %d\n", _tick_count);
		for (i=0L ; i++ != 1000000L ; );
	}
	return(0);
}

#endif



/*
 *
 *	Copyright (c) 1995-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */



