

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 16 "istream.d"
#include <ctype.h> 
#include <string.h> 

#include "dpp.h" 

#define MAXBUF 4096 
#define MAXWORDSZ 256 


#define strne(a, b) strcmp(a, b) 
#define streq(a, b) !strcmp(a, b) 

#define istart(x) (isalpha(x) || (x) == '_') 
#define irest(x) (isalnum(x) || (x) == '_') 


#ifdef unix 
#define RMODE "r" 
#define WMODE "w" 
#else 
#define RMODE "rt" 
#define WMODE "wt" 
#endif 

#define	CLASS	InputStream_c
#define	ivType	InputStream_iv_t

#include "generics.h"

object	InputStream_c;


#line 50 "istream.c"
typedef struct  _InputStream_iv_t  {
	object iStream;
	long iLine;
	char * iBuf;
	char * iPtr;
}	InputStream_iv_t;


#line 48 "istream.d"
extern objrtn open_file(char *file,char *mode); 


cmeth objrtn InputStream_cm_gNew(object self)
{ 
	return gShouldNotImplement(self, "gNew"); 
} 

cmeth objrtn InputStream_cm_gNewWithStr(object self, char *file)
{ 
	object s, obj; 
	ivType *iv; 

	s = open_file(file, RMODE); 
	if (!s) 
		return NULL; 
	obj = oSuper(InputStream_c, gNew, self)(self); 
	iv = ivPtr(obj); 
	iv->iStream = s; 
	iv->iBuf = Tnalloc(char, MAXBUF); 
	*iv->iBuf = '\0'; 
	iv->iPtr = iv->iBuf; 
	return obj; 
} 

imeth objrtn InputStream_im_gDispose(object self)
{ InputStream_iv_t *iv = GetIVs(InputStream, self);
	gDispose(iv->iStream); 
	free(iv->iBuf); 
	return oSuper(InputStream_c, gDispose, self)(self); 
} 

imeth objrtn InputStream_im_gGCDispose(object self)
{ InputStream_iv_t *iv = GetIVs(InputStream, self);
	free(iv->iBuf); 
	return oSuper(InputStream_c, gGCDispose, self)(self); 
} 



static int get_line(ivType *iv) 
{ 
	char *tbuf; 
	int something = 0, i; 

	tbuf = iv->iBuf; 
	*tbuf = '\0'; 
	while (1) { 
		if (!gGets(iv->iStream, tbuf, MAXBUF-strlen(iv->iBuf))) 
			break; 
		iv->iLine++; 
		something = 1; 
		i = strlen(tbuf) - 1; 
		while (i >= 0 && (tbuf[i] == '\n' || tbuf[i] == '\r')) 
			i--; 
		if (i < 0 || tbuf[i] != '\\') { 
			tbuf[i+1] = '\0'; 
			break; 
		} 
		tbuf[i] = '\0'; 
		tbuf += i; 
	} 
	return something; 
} 


#define IS(a, b) *iv->iPtr == a && iv->iPtr[1] == b 
#define IS3(a, b, c) *iv->iPtr == a && iv->iPtr[1] == b && iv->iPtr[2] == c 

#define CODE_STATE 1 
#define COMMENT_STATE 2 



static int next_token(ivType *iv) 
{ 
	int state = CODE_STATE; 

	while (1) { 
		if (!*iv->iPtr) 
			if (get_line(iv)) 
			iv->iPtr = iv->iBuf; 
		else 
			return 0; 
		else if (state == CODE_STATE) { 
			if (isspace(*iv->iPtr)) 
				iv->iPtr++; 
			else if (IS('/', '/')) 
				*iv->iPtr = '\0'; 
			else if (IS('/', '*')) { 
				state = COMMENT_STATE; 
				iv->iPtr += 2; 
			} else 
				return 1; 
		} else { 
			if (IS('*', '/')) { 
				iv->iPtr += 2; 
				state = CODE_STATE; 
			} else 
				iv->iPtr++; 
		} 
	} 

} 

imeth objrtn InputStream_im_gNextToken(object self)
{ InputStream_iv_t *iv = GetIVs(InputStream, self);
	char *w, token[MAXWORDSZ]; 
	int i; 

	if (!next_token(iv)) 
		return NULL; 
	w = token; 
	if (istart(*iv->iPtr)) 
		for (i=0 ; ++i <= MAXWORDSZ && irest(*iv->iPtr) ;) 
		*w++ = *iv->iPtr++; 
	else 
		if (IS3('<', '<', '=') || 
		IS3('>', '>', '=') || 
		IS3(':', ':', '*') || 
		IS3('-', '>', '*') || 
		IS3('.', '.', '.')) { 
		*w++ = *iv->iPtr++; 
		*w++ = *iv->iPtr++; 
		*w++ = *iv->iPtr++; 
	} else if (IS('*', '=') || 
		IS('/', '=') || 
		IS('%', '=') || 
		IS('+', '=') || 
		IS('-', '=') || 
		IS('&', '=') || 
		IS('^', '=') || 
		IS('|', '=') || 
		IS('&', '&') || 
		IS('|', '|') || 
		IS('=', '=') || 
		IS('!', '=') || 
		IS('<', '<') || 
		IS('>', '>') || 
		IS('<', '=') || 
		IS('>', '=') || 
		IS('-', '-') || 
		IS('+', '+') || 
		IS(':', ':') || 
		IS('.', '*') || 
		IS('-', '>')) { 
		*w++ = *iv->iPtr++; 
		*w++ = *iv->iPtr++; 
	} else if (*iv->iPtr == '"' || *iv->iPtr == '\'') { 
		char type = *iv->iPtr; 
		*w++ = *iv->iPtr++; 
		while (*iv->iPtr && *iv->iPtr != type) { 
			*w++ = *iv->iPtr; 
			if (*iv->iPtr == '\\' && iv->iPtr[1]) 
				*w++ = *++iv->iPtr; 
			++iv->iPtr; 
		} 
		if (*iv->iPtr) 
			*w++ = *iv->iPtr++; 
	} else if (isdigit(*iv->iPtr) || *iv->iPtr == '.' && isdigit(iv->iPtr[1])) { 
		int hex; 

		if (hex = (*iv->iPtr == '0' && (iv->iPtr[1] == 'x' || iv->iPtr[1] == 'X'))) { 
			*w++ = *iv->iPtr++; 
			*w++ = *iv->iPtr++; 
		} 
		while ((hex ? isxdigit(*iv->iPtr) : isdigit(*iv->iPtr)) || *iv->iPtr == '.' || *iv->iPtr == 'e' || *iv->iPtr == 'E' 
			|| ((*iv->iPtr=='-' || *iv->iPtr=='+') && 
			(iv->iPtr[-1] == 'e' || iv->iPtr[-1] == 'E')) ) 
			*w++ = *iv->iPtr++; 
		if (*iv->iPtr == 'u' || *iv->iPtr == 'U' || *iv->iPtr == 'l' || *iv->iPtr == 'L') 
			*w++ = *iv->iPtr++; 
		if (*iv->iPtr == 'u' || *iv->iPtr == 'U' || *iv->iPtr == 'l' || *iv->iPtr == 'L') 
			*w++ = *iv->iPtr++; 
	} else 
		*w++ = *iv->iPtr++; 
	*w = '\0'; 

	i = isspace(*iv->iPtr) || !*iv->iPtr || 
		iv->iPtr[0] == '/' && iv->iPtr[1] == '*' || 
		iv->iPtr[0] == '/' && iv->iPtr[1] == '/'; 
	return gNewToken(Token, token, iv->iLine, i); 
} 


#line 245 "istream.c"

objrtn	InputStream_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (InputStream_c) {
		LEAVECRITICALSECTION(cs);
		return InputStream_c;
	}
	INHIBIT_THREADER;
	InputStream_c = gNewClass(Class, "InputStream", sizeof(InputStream_iv_t), 0, END);
	cMethodFor(InputStream, gNewWithStr, InputStream_cm_gNewWithStr);
	cMethodFor(InputStream, gNew, InputStream_cm_gNew);
	iMethodFor(InputStream, gDispose, InputStream_im_gDispose);
	iMethodFor(InputStream, gGCDispose, InputStream_im_gGCDispose);
	iMethodFor(InputStream, gNextToken, InputStream_im_gNextToken);
	iMethodFor(InputStream, gDeepDispose, InputStream_im_gDispose);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return InputStream_c;
}



