
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


#include <string.h>


defclass  Stream  {
 init:  class_init;
};


object	stdoutStream_o, stdinStream_o, stderrStream_o, traceStream_o;


imeth	int	gPuts(char *str)	/*  or String object  */
{
	if (IsObj((object)str))
		str = gStringValue((object)str);
	return gWrite(self, str, strlen(str));
}

imeth	int	gPutc(int i)
{
	char	c = (char) i;
	return 1 == (gWrite(self, &c, 1)) ? i : EOF;
}

ivmeth	int	vPrintf(char *fmt, ...)
{
	char	buf[256];
	MAKE_REST(fmt);

	vsprintf(buf, fmt, _rest_);
	return gWrite(self, buf, strlen(buf));
}

imeth	gCopy, gDeepCopy ()
{
	return gShouldNotImplement(self, "Copy/DeepCopy");
}

static	void	class_init(void)
{
	Dynace;
	RegisterVariable(stdoutStream_o);
	RegisterVariable(stderrStream_o);
	RegisterVariable(stdinStream_o);
	RegisterVariable(traceStream_o);
}




/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

