

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 15 "strassoc.d"
#include <string.h> 
#include <math.h> 
#include "memalloc.h" 

#define	CLASS	StringAssociation_c
#define	ivType	StringAssociation_iv_t

#include "generics.h"

object	StringAssociation_c;


#line 30 "strassoc.c"
typedef struct  _StringAssociation_iv_t  {
	char * iKey;
	object iValue;
}	StringAssociation_iv_t;



#line 25 "strassoc.d"
cmeth objrtn StringAssociation_cm_gNewWithStrObj(object self, char *key, object value)
{ 
	int len = key ? strlen(key) : 0; 
	object assoc; 
	ivType *iv; 

	ChkArgNul(value, 3); 
	assoc = oSuper(StringAssociation_c, gNew, self)(self); 
	iv = ivPtr(assoc); 
	iv->iKey = (char *) MA_malloc(len+1, &iv->iKey); 
	strcpy(iv->iKey, key ? key : ""); 
	iv->iValue = value; 
	return assoc; 
} 

imeth objrtn StringAssociation_im_gDeepCopy(object self)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	object nobj; 
	ivType *iv2; 

	nobj = oSuper(StringAssociation_c, gDeepCopy, self)(self); 
	iv2 = ivPtr(nobj); 
	if (iv->iKey) { 
		iv2->iKey = (char *) MA_malloc(strlen(iv->iKey)+1, &iv2->iKey); 
		strcpy(iv2->iKey, iv->iKey); 
	} 
	if (iv->iValue) 
		iv2->iValue = gDeepCopy(iv->iValue); 
	return nobj; 
} 

imeth objrtn StringAssociation_im_gCopy(object self)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	object nobj; 
	ivType *iv2; 

	nobj = oSuper(StringAssociation_c, gCopy, self)(self); 
	iv2 = ivPtr(nobj); 
	if (iv->iKey) { 
		iv2->iKey = (char *) MA_malloc(strlen(iv->iKey)+1, &iv2->iKey); 
		strcpy(iv2->iKey, iv->iKey); 
	} 
	iv2->iValue = iv->iValue; 
	return nobj; 
} 

imeth objrtn StringAssociation_im_gValue(object self)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	return iv->iValue; 
} 

imeth objrtn StringAssociation_im_gChangeValue(object self, object value)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	object ret; 
	ChkArgNul(value, 2); 
	ret = iv->iValue; 
	iv->iValue = value; 
	return ret; 
} 

imeth char * StringAssociation_im_gStringKey(object self)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	return iv->iKey; 
} 

imeth objrtn StringAssociation_im_gChangeStringKey(object self, char *key)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	int len = key ? strlen(key) : 0; 

	if (iv->iKey) { 
		if (len > (int) strlen(iv->iKey)) 
			iv->iKey = (char *) MA_realloc(iv->iKey, len+1); 
	} else 
		iv->iKey = (char *) MA_malloc(len+1, &iv->iKey); 
	strcpy(iv->iKey, key ? key : ""); 
	return self; 
} 

imeth objrtn StringAssociation_im_gDispose(object self)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	if (iv->iKey) 
		MA_free(iv->iKey); 
	return oSuper(StringAssociation_c, gDispose, self)(self); 
} 

imeth objrtn StringAssociation_im_gDeepDispose(object self)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	if (iv->iKey) 
		MA_free(iv->iKey); 
	if (iv->iValue) 
		gDeepDispose(iv->iValue); 
	return oSuper(StringAssociation_c, gDeepDispose, self)(self); 
} 

imeth objrtn StringAssociation_im_gStringRepValue(object self)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	object s, t; 

	t = iv->iValue ? gStringRepValue(iv->iValue) : (object) NULL; 
	s = vSprintf(String, "( \"%s\", ", iv->iKey ? iv->iKey : "(null)"); 
	vBuild(s, NULL, t ? (char *) t : "(null)", " )", NULL); 
	if (t) 
		gDispose(t); 
	return s; 
} 

imeth int StringAssociation_im_gHash(object self)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	register char c = 'a'; 
	char *s = iv->iKey; 
	double t; 
	register unsigned short k=0; 

	if (s) 
		while (*s) 
		k += *s++ ^ c++; 
	t = .6125423371 * k; 
	t = t < 0.0 ? -t : t; 
	return (int) (BIG_INT * (t - floor(t))); 
} 

imeth int StringAssociation_im_gCompare(object self, object arg)
{ StringAssociation_iv_t *iv = GetIVs(StringAssociation, self);
	ChkArg(arg, 2); 
	return strcmp(iv->iKey?iv->iKey:"", gStringKey(arg)); 
} 


#line 167 "strassoc.c"

objrtn	StringAssociation_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (StringAssociation_c) {
		LEAVECRITICALSECTION(cs);
		return StringAssociation_c;
	}
	INHIBIT_THREADER;
	Association_initialize();
	if (StringAssociation_c)  {
		ENABLE_THREADER;
		LEAVECRITICALSECTION(cs);
		return StringAssociation_c;
	}
	StringAssociation_c = gNewClass(Class, "StringAssociation", sizeof(StringAssociation_iv_t), 0, Association, END);
	cMethodFor(StringAssociation, gNewWithStrObj, StringAssociation_cm_gNewWithStrObj);
	iMethodFor(StringAssociation, gCompare, StringAssociation_im_gCompare);
	iMethodFor(StringAssociation, gStringKey, StringAssociation_im_gStringKey);
	iMethodFor(StringAssociation, gDispose, StringAssociation_im_gDispose);
	iMethodFor(StringAssociation, gChangeStringKey, StringAssociation_im_gChangeStringKey);
	iMethodFor(StringAssociation, gValue, StringAssociation_im_gValue);
	iMethodFor(StringAssociation, gGCDispose, StringAssociation_im_gDispose);
	iMethodFor(StringAssociation, gStringRepValue, StringAssociation_im_gStringRepValue);
	iMethodFor(StringAssociation, gHash, StringAssociation_im_gHash);
	iMethodFor(StringAssociation, gChangeValue, StringAssociation_im_gChangeValue);
	iMethodFor(StringAssociation, gCopy, StringAssociation_im_gCopy);
	iMethodFor(StringAssociation, gDeepDispose, StringAssociation_im_gDeepDispose);
	iMethodFor(StringAssociation, gDeepCopy, StringAssociation_im_gDeepCopy);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return StringAssociation_c;
}



