
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


#include <math.h>

defclass  Pointer  {
	void	*iVal;
};

cmeth	gNewWithPtr, <vNew> (void *val)
{
	object	obj = gNew(super);
	ivType	*iv = ivPtr(obj);
	iVal = val;
	return(obj);
}

imeth	void	*gPointerValue()
{
	return iVal;
}

imeth	gChangeValue(val)
{
	iVal = (void *) val;
	return self;
}

imeth	int	gHash()
{
	double	t;

	t = .6125423371	* (double) (unsigned long) iVal;
	t = t < 0.0 ? -t : t;
	return (int) (BIG_INT * (t - floor(t)));
}

imeth	int	gCompare(obj)
{
	void	*sv, *ov;

	ChkArg(obj, 2);
	if (ClassOf(obj) != CLASS)
		return gCompare(super, obj);
	if ((sv=iVal) < (ov=ivPtr(obj)->iVal))
		return -1;
	else if (sv == ov)
		return 0;
	else
		return 1;
}

imeth	gStringRepValue()
{
	return vSprintf(String, "%lp", iVal);
}


/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */
