
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */



defclass  ObjectAssociation : LookupKey  {
	iValue;
};

cmeth	gNewWithObjObj, <vNew> (key, val)
{
	object	assoc;
	ivType	*iv;

	ChkArgNul(key, 2);
	ChkArgNul(val, 3);
	assoc = gNewWithObj(super, key);
	iv = ivPtr(assoc);
	iValue = val;
	return assoc;
}

imeth	gDeepCopy()
{
	object	nobj;

	nobj = gDeepCopy(super);
	ivPtr(nobj)->iValue = iValue ? gDeepCopy(iValue) : NULL;
	return nobj;
}

imeth	gValue()
{
	return iValue;
}

imeth	gChangeValue(value)
{
	object	ret;
	ChkArgNul(value, 2);
	ret = iValue;
	iValue = value;
	return ret;
}

imeth	object	gDeepDispose()
{
	if (iValue)
		gDeepDispose(iValue);
	return gDeepDispose(super);
}

imeth	gStringRepValue()
{
	object	s, k, v;

	k = gKey(self);
	k = k ? gStringRepValue(k) : gNewWithStr(String,"(null)");
	v = iValue ? gStringRepValue(iValue) : gNewWithStr(String,"(null)");
	s = vBuild(String, "( ", k, ", ", v, " )", NULL);
	gDispose(k);
	gDispose(v);
	return s;
}




/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

