

/*                                      
 *
 *      Copyright (c) 1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */


defclass Memory {
	unsigned	iSize;
	void		*iPtr;
};

#include <string.h>

cmeth	gNewWithInt(int size)
{
	object	obj = gNew(super);
	accessIVsOf(obj);
	iSize = (unsigned) size;
	iPtr = calloc(iSize ? iSize : 1, sizeof(char));
	if (!iPtr)
		gError(Dynace, "Dynace: out of memory.");
	return obj;
}

imeth	gDispose, gDeepDispose, gGCDispose ()
{
	if (iPtr)
		free(iPtr);
	return gDispose(super);
}

imeth	void	*gPointerValue()
{
	return iPtr;
}

imeth	int	gSize()
{
	return iSize;
}

imeth	gResize(int size)
{
	iSize = (unsigned) size;
	iPtr = realloc(iPtr, iSize ? iSize : 1);
	if (!iPtr)
		gError(Dynace, "Dynace: out of memory.");
	return self;
}

imeth	gDeepCopy, gCopy ()
{
	object	cpy = gNewWithInt(CLASS, (int) iSize);
	ivType	*iv2 = ivPtr(cpy);
	memcpy(iv2->iPtr, iPtr, iSize);
	return cpy;
}



/*                                      
 *
 *      Copyright (c) 1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */


