

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 16 "lowfile.d"
#include <fcntl.h> 
#include <sys/types.h> 
#include <sys/stat.h> 
#ifndef unix 
#include <io.h> 
#endif 

#if defined(sparc) || defined(unix) 
#include <unistd.h> 
#define tell(h) lseek(h, 0L, SEEK_CUR) 
#endif 

#define	CLASS	LowFile_c
#define	ivType	LowFile_iv_t

#include "generics.h"

object	LowFile_c;


#line 38 "lowfile.c"
typedef struct  _LowFile_iv_t  {
	object iName;
	int iHandle;
}	LowFile_iv_t;



#line 36 "lowfile.d"
cmeth objrtn LowFile_cm_gNew(object self)
{ 
	return gShouldNotImplement(self, "gNew"); 
} 

cmeth objrtn LowFile_cm_gOpenLowFile(object self, char *name, int oflag, int pmode)
{ 
	object obj; 
	ivType *iv; 
	int handle; 

	if (IsObj((object) name)) 
		name = gStringValue((object) name); 
	handle = open(name, oflag, pmode); 
	if (handle == -1) 
		return NULL; 
	obj = oSuper(LowFile_c, gNew, self)(self); 
	iv = ivPtr(obj); 
	iv->iName = gNewWithStr(String, name); 
	iv->iHandle = handle; 
	return obj; 
} 


imeth objrtn LowFile_im_gDispose(object self)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	close(iv->iHandle); 
	gDispose(iv->iName); 
	return oSuper(LowFile_c, gDispose, self)(self); 
} 

imeth int LowFile_im_gRead(object self, char *buf, unsigned n)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	return read(iv->iHandle, buf, n); 
} 

imeth int LowFile_im_gWrite(object self, char *buf, unsigned n)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	return write(iv->iHandle, buf, n); 
} 

imeth char * LowFile_im_gGets(object self, char *buf, int sz)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	int h = iv->iHandle; 
	int i, r; 
	char c; 

	if (sz <= 0) 
		return NULL; 
	if (sz-- == 1) { 
		*buf = '\0'; 
		return buf; 
	} 
	for (i=0 ; i < sz ; ) { 
		r = read(h, &c, 1); 
		if (!r && !i || r < 0) 
			return NULL; 
		if (!r) 
			break; 
		buf[i++] = c; 
		if (c == '\n') 
			break; 
	} 
	buf[i] = '\0'; 
	return buf; 
} 

imeth long LowFile_im_gAdvance(object self, long n)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	int h = iv->iHandle; 
	long p = tell(h); 
	long r = lseek(h, n, SEEK_CUR); 
	return r >= 0L ? r-p : 0L; 
} 

imeth long LowFile_im_gRetreat(object self, long n)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	int h = iv->iHandle; 
	long p = tell(h); 
	long r = lseek(h, -n, SEEK_CUR); 
	return r >= 0L ? p-r : 0L; 
} 

imeth long LowFile_im_gSeek(object self, long n)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	long r = lseek(iv->iHandle, n, SEEK_SET); 
	return r; 
} 

imeth long LowFile_im_gPosition(object self)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	return tell(iv->iHandle); 
} 

imeth long LowFile_im_gLength(object self)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	struct stat sb; 
	int r; 

	r = fstat(iv->iHandle, &sb); 
	return r ? -1L : sb.st_size; 
} 

imeth char * LowFile_im_gName(object self)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	return gStringValue(iv->iName); 
} 

imeth int LowFile_im_gEndOfStream(object self)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
#ifndef unix 
		return eof(iv->iHandle); 
#else 
		gShouldNotImplement(self, "EndOfStream"); 
	iv->iHandle = iv->iHandle; 
	return 0; 
#endif 
	} 

imeth int LowFile_im_gFileHandle(object self)
{ LowFile_iv_t *iv = GetIVs(LowFile, self);
	return iv->iHandle; 
} 


#line 172 "lowfile.c"

objrtn	LowFile_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (LowFile_c) {
		LEAVECRITICALSECTION(cs);
		return LowFile_c;
	}
	INHIBIT_THREADER;
	Stream_initialize();
	if (LowFile_c)  {
		ENABLE_THREADER;
		LEAVECRITICALSECTION(cs);
		return LowFile_c;
	}
	LowFile_c = gNewClass(Class, "LowFile", sizeof(LowFile_iv_t), 0, Stream, END);
	cMethodFor(LowFile, gNew, LowFile_cm_gNew);
	cMethodFor(LowFile, gOpenLowFile, LowFile_cm_gOpenLowFile);
	iMethodFor(LowFile, gRetreat, LowFile_im_gRetreat);
	iMethodFor(LowFile, gPosition, LowFile_im_gPosition);
	iMethodFor(LowFile, gLength, LowFile_im_gLength);
	iMethodFor(LowFile, gWrite, LowFile_im_gWrite);
	iMethodFor(LowFile, gEndOfStream, LowFile_im_gEndOfStream);
	iMethodFor(LowFile, gSeek, LowFile_im_gSeek);
	iMethodFor(LowFile, gAdvance, LowFile_im_gAdvance);
	iMethodFor(LowFile, gDispose, LowFile_im_gDispose);
	iMethodFor(LowFile, gName, LowFile_im_gName);
	iMethodFor(LowFile, gGets, LowFile_im_gGets);
	iMethodFor(LowFile, gGCDispose, LowFile_im_gDispose);
	iMethodFor(LowFile, gDeepDispose, LowFile_im_gDispose);
	iMethodFor(LowFile, gFileHandle, LowFile_im_gFileHandle);
	iMethodFor(LowFile, gRead, LowFile_im_gRead);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return LowFile_c;
}



