
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


#include <math.h>


defclass  LongInteger : Number  {
	long	iVal;
};

cmeth	gNewWithLong, <vNew> (long val)
{
	object	obj = gNew(super);
	ivType	*iv = ivPtr(obj);
	iVal = val;
	return(obj);
}

imeth	int	gHash()
{
	double	t;

	t = .6125423371	* (unsigned long) iVal;
	t = t < 0.0 ? -t : t;
	return (int) (BIG_INT * (t - floor(t)));
}

imeth	int	gCompare(obj)
{
	long	sv, ov;

	ChkArg(obj, 2);
	if (ClassOf(obj) != CLASS  &&  ClassOf(obj) != Date)
		return gCompare(super, obj);
	if ((sv=iVal) < (ov=ivPtr(obj)->iVal))
		return -1;
	else if (sv == ov)
		return 0;
	else
		return 1;
}

imeth	gStringRepValue()
{
	return vSprintf(String, "%ld", iVal);
}

imeth	char	gCharValue()
{
	return (char) iVal;
}

imeth	short	gShortValue()
{
	return (short) iVal;
}

imeth	unsigned short	gUnsignedShortValue()
{
	return (unsigned short) iVal;
}

imeth	long	gLongValue()
{
	return (long) iVal;
}

imeth	double	gDoubleValue()
{
	return (double) iVal;
}

imeth	void	*gPointerValue()
{
	return (void *) &iVal;
}

imeth	gChangeValue(val)
{
	ChkArg(val, 2);
	iVal = gLongValue(val);
	return self;
}

imeth	gChangeCharValue(int val)
{
	iVal = (long) val;
	return self;
}

imeth	gChangeShortValue(int val)
{
	iVal = (long) val;
	return self;
}

imeth	gChangeUShortValue(unsigned val)
{
	iVal = (long) val;
	return self;
}

imeth	gChangeLongValue(long val)
{
	iVal = (long) val;
	return self;
}

imeth	gChangeDoubleValue(double val)
{
	iVal = (long) val;
	return self;
}


/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */
