
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */



defclass  LinkValue : Link  {
	iValue;		/*  value referenced by this link	*/
};


cmeth	gNewWithObj, <vNew> (value)
{
	object	lnk;
	ivType	*iv;

	ChkArgNul(value, 2);
	lnk = gNew(super);
	iv = ivPtr(lnk);
	iValue = value;
	return lnk;
}

imeth	gDeepCopy()
{
	object	nobj;

	nobj = gDeepCopy(super);
	ivPtr(nobj)->iValue = iValue ? gDeepCopy(iValue) : NULL;
	return nobj;
}

imeth	object	gDeepDispose()
{
	if (iValue)
		gDeepDispose(iValue);
	return gDeepDispose(super);
}

imeth	gValue()
{
	return iValue;
}

imeth	gChangeValue(value)
{
	ChkArgNul(value, 2);
	iValue = value;
	return self;
}

imeth	gStringRepValue()
{
	return iValue ? gStringRepValue(iValue) : gNewWithStr(String, "(null)");
}

imeth	gStringRep()
{
	object	a, b, s;

	a = gStringRepValue(super);
	b = iValue ? gStringRepValue(iValue) : gNewWithStr(String, "(null)");
	s = vBuild(String, gName(ClassOf(self)), " (", a, ", ", b, ")\n", NULL);
	gDispose(a);
	gDispose(b);
	return s;
}



/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */
