
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */




defclass  LinkList : Link  {
	int	iNelm;
	CRITICALSECTION	iCS;	/*  in support of native threads  */
};

#define FIRST	gNext
#define LAST	gPrevious

cmeth	gNew, <vNew> ()
{
	object	obj = gNew(super);
	accessIVsOf(obj);
	INITIALIZECRITICALSECTION(iCS);
	gInitLink(obj, obj, obj, obj);
	return obj;
}

imeth	gIncNelm(int inc)
{
	if (0 > (iNelm += inc))
		iNelm = 0;
	return self;
}

imeth	int	gSize()
{
	return iNelm;
}

imeth	gFirst()
{
	object	r;
	ENTERCRITICALSECTION(iCS);
	r = FIRST(self);
	LEAVECRITICALSECTION(iCS);
	return r;
}

imeth	gLast()
{
	object	r;
	ENTERCRITICALSECTION(iCS);
	r = LAST(self);
	LEAVECRITICALSECTION(iCS);
	return r;
}

imeth	gAddFirst(lnk)
{
	ChkArg(lnk, 2);
	ENTERCRITICALSECTION(iCS);
	gAddAfter(self, lnk);
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	gAddLast(lnk)
{
	ChkArg(lnk, 2);
	ENTERCRITICALSECTION(iCS);
	gAddBefore(self, lnk);
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	gInsertObjAt(lnk, int idx)
{
	ChkArg(lnk, 2);
	ENTERCRITICALSECTION(iCS);
	if (!idx  ||  idx < -iNelm)
		gAddAfter(self, lnk);  	// beginning
	else if (idx == -1  ||  idx >= iNelm)
		gAddBefore(self, lnk);	// end
	else if (idx > 0)
		gAddAfter(gNth(self, idx), lnk);
	else
		gAddBefore(gNth(self, idx+1), lnk);
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	gDisposeFirst()
{
	ENTERCRITICALSECTION(iCS);
	if (iNelm)
		gDispose(FIRST(self));
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	gDeepDisposeFirst()
{
	ENTERCRITICALSECTION(iCS);
	if (iNelm)
		gDeepDispose(FIRST(self));
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	gRemoveFirst()
{
	object	r;
	ENTERCRITICALSECTION(iCS);
	r = iNelm ? gRemove(FIRST(self)) : NULLOBJ;
	LEAVECRITICALSECTION(iCS);
	return r;
}

imeth	gDisposeLast()
{
	ENTERCRITICALSECTION(iCS);
	if (iNelm)
		gDispose(LAST(self));
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	gDeepDisposeLast()
{
	ENTERCRITICALSECTION(iCS);
	if (iNelm)
		gDeepDispose(LAST(self));
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	gRemoveLast()
{
	object	r;
	ENTERCRITICALSECTION(iCS);
	if (iNelm)
		r = gRemove(LAST(self));
	else
		r = NULL;
	LEAVECRITICALSECTION(iCS);
	return r;
}

imeth	gDisposeAllNodes()
{
	object	obj;

	ENTERCRITICALSECTION(iCS);
	while (obj = FIRST(self))
		gDispose(obj);
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	gDeepDisposeAllNodes()
{
	object	obj;

	ENTERCRITICALSECTION(iCS);
	while (obj = FIRST(self))
		gDeepDispose(obj);
	LEAVECRITICALSECTION(iCS);
	return self;
}

imeth	object	gDispose()
{
	gDisposeAllNodes(self);
	DELETECRITICALSECTION(iCS);
	return gDispose(super);
}

imeth	object	gDeepDispose()
{
	gDeepDisposeAllNodes(self);
	DELETECRITICALSECTION(iCS);
	return gDeepDispose(super);
}

imeth	gSequence()
{
	return gNewWithObj(LinkSequence, FIRST(self));
}

imeth	gCopy()
{
	object	nobj;
	ivType	*iv2;
	object	lnk;

	ENTERCRITICALSECTION(iCS);
	nobj = gCopy(super);
	iv2 = ivPtr(nobj);
	iv2->iNelm = 0;
	gInitLink(nobj, nobj, nobj, nobj);
	for (lnk=FIRST(self) ; lnk ; lnk = gNext(lnk))
		gAddBefore(nobj, gCopy(lnk));
	LEAVECRITICALSECTION(iCS);
	return nobj;
}

imeth	gDeepCopy()
{
	object	nobj;
	ivType	*iv2;
	object	lnk;

	ENTERCRITICALSECTION(iCS);
	nobj = gDeepCopy(super);
	iv2 = ivPtr(nobj);
	iv2->iNelm = 0;
	gInitLink(nobj, nobj, nobj, nobj);
	for (lnk=FIRST(self) ; lnk ; lnk = gNext(lnk))
		gAddBefore(nobj, gDeepCopy(lnk));
	LEAVECRITICALSECTION(iCS);
	return nobj;
}

imeth	gStringRep()
{
	object	lnk, s, t;

	ENTERCRITICALSECTION(iCS);
	s = gStringRepValue(super);
	gAppend(s, (object) "  (");
	for (lnk = FIRST(self) ; lnk ; )  {
		t = gStringRepValue(lnk);
		if (lnk = gNext(lnk))
			vBuild(s, NULL, t, ", ", NULL);
		else
			gAppend(s, t);
		gDispose(t);
	}
	gAppend(s, (object) ")\n");
	LEAVECRITICALSECTION(iCS);
	return s;
}

imeth	gEnterCriticalSection()
{
	ENTERCRITICALSECTION(iCS);
	return self;
}

imeth	gLeaveCriticalSection()
{
	LEAVECRITICALSECTION(iCS);
	return self;
}




/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

