

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0




#define	CLASS	Link_c
#define	ivType	Link_iv_t

#include "generics.h"

object	Link_c;


#line 26 "link.c"
typedef struct  _Link_iv_t  {
	object iPrev;
	object iNext;
	object iList;
}	Link_iv_t;



#line 24 "link.d"
imeth objrtn Link_im_gNext(object self)
{ Link_iv_t *iv = GetIVs(Link, self);
	return iv->iNext == iv->iList ? NULLOBJ : iv->iNext; 
} 

imeth objrtn Link_im_gPrevious(object self)
{ Link_iv_t *iv = GetIVs(Link, self);
	return iv->iPrev == iv->iList ? NULLOBJ : iv->iPrev; 
} 

imeth objrtn Link_im_gList(object self)
{ Link_iv_t *iv = GetIVs(Link, self);
	return iv->iList; 
} 

imeth objrtn Link_im_gChangeNext(object self, object next)
{ Link_iv_t *iv = GetIVs(Link, self);
	ChkArgNul(next, 2); 
	iv->iNext = next; 
	return self; 
} 

imeth objrtn Link_im_gChangePrevious(object self, object prev)
{ Link_iv_t *iv = GetIVs(Link, self);
	ChkArgNul(prev, 2); 
	iv->iPrev = prev; 
	return self; 
} 

imeth objrtn Link_im_gInitLink(object self, object list, object prev, object next)
{ Link_iv_t *iv = GetIVs(Link, self);
	ChkArgNul(list, 2); 
	ChkArgNul(prev, 3); 
	ChkArgNul(next, 4); 
	iv->iList = list; 
	iv->iPrev = prev; 
	iv->iNext = next; 
	return self; 
} 

imeth objrtn Remove(object self)
{ Link_iv_t *iv = GetIVs(Link, self);
#ifdef NATIVE_THREADS 
		if (iv->iList) 
		gEnterCriticalSection(iv->iList); 
#endif 
		if (iv->iNext && iv->iNext != self) 
		ivPtr(iv->iNext)->iPrev = iv->iPrev; 
	if (iv->iPrev && iv->iPrev != self) 
		ivPtr(iv->iPrev)->iNext = iv->iNext; 
	if (iv->iList && iv->iList != self) 
		gIncNelm(iv->iList, -1); 
	iv->iList = iv->iNext = iv->iPrev = NULLOBJ; 
#ifdef NATIVE_THREADS 
		if (iv->iList) 
		gLeaveCriticalSection(iv->iList); 
#endif 
		return self; 
} 

imeth objrtn Link_im_gDispose(object self)
{ 
	Remove(self); 
	return oSuper(Link_c, gDispose, self)(self); 
} 

imeth objrtn Link_im_gDeepDispose(object self)
{ 
	Remove(self); 
	return oSuper(Link_c, gDeepDispose, self)(self); 
} 



imeth objrtn AddBefore(object self, object lnk)
{ Link_iv_t *iv = GetIVs(Link, self);
	ivType *iv2; 

	ChkArg(lnk, 2); 
	if (self == lnk) 
		return self; 
#ifdef NATIVE_THREADS 
		if (iv->iList) 
		gEnterCriticalSection(iv->iList); 
#endif 
		iv2 = ivPtr(lnk); 
	if (iv2->iList || iv2->iNext || iv2->iPrev) 
		gError(self, "Attempt to add a node to a list which is a member of another list."); 
	if (iv2->iPrev = iv->iPrev) 
		ivPtr(iv2->iPrev)->iNext = lnk; 
	iv2->iNext = self; 
	iv->iPrev = lnk; 
	if (iv2->iList = iv->iList) 
		gIncNelm(iv->iList, 1); 
#ifdef NATIVE_THREADS 
		if (iv->iList) 
		gLeaveCriticalSection(iv->iList); 
#endif 
		return self; 
} 



imeth objrtn AddAfter(object self, object lnk)
{ Link_iv_t *iv = GetIVs(Link, self);
	ivType *iv2; 

	ChkArg(lnk, 2); 
	if (self == lnk) 
		return self; 
#ifdef NATIVE_THREADS 
		if (iv->iList) 
		gEnterCriticalSection(iv->iList); 
#endif 
		iv2 = ivPtr(lnk); 
	if (iv2->iList || iv2->iNext || iv2->iPrev) 
		gError(self, "Attempt to add a node to a list which is a member of another list."); 
	if (iv2->iNext = iv->iNext) 
		ivPtr(iv2->iNext)->iPrev = lnk; 
	iv2->iPrev = self; 
	iv->iNext = lnk; 
	if (iv2->iList = iv->iList) 
		gIncNelm(iv->iList, 1); 
#ifdef NATIVE_THREADS 
		if (iv->iList) 
		gLeaveCriticalSection(iv->iList); 
#endif 
		return self; 
} 



imeth objrtn Link_im_gMoveBeginning(object self)
{ Link_iv_t *iv = GetIVs(Link, self);
	ivType *iv2; 

	if (!iv->iList || self == iv->iList) 
		return NULLOBJ; 
#ifdef NATIVE_THREADS 
		gEnterCriticalSection(iv->iList); 
#endif 
		iv2 = ivPtr(iv->iList); 
	if (iv2->iNext == self) { 
#ifdef NATIVE_THREADS 
			gLeaveCriticalSection(iv->iList); 
#endif 
			return self; 
	} 
	Remove(self); 
	AddAfter(iv->iList, self); 
#ifdef NATIVE_THREADS 
		gLeaveCriticalSection(iv->iList); 
#endif 
		return self; 
} 



imeth objrtn Link_im_gMoveEnd(object self)
{ Link_iv_t *iv = GetIVs(Link, self);
	ivType *iv2; 

	if (!iv->iList || self == iv->iList) 
		return NULLOBJ; 
#ifdef NATIVE_THREADS 
		gEnterCriticalSection(iv->iList); 
#endif 
		iv2 = ivPtr(iv->iList); 
	if (iv2->iPrev == self) { 
#ifdef NATIVE_THREADS 
			gLeaveCriticalSection(iv->iList); 
#endif 
			return self; 
	} 
	Remove(self); 
	AddBefore(iv->iList, self); 
#ifdef NATIVE_THREADS 
		gLeaveCriticalSection(iv->iList); 
#endif 
		return self; 
} 



imeth objrtn Link_im_gMoveAfter(object self, object lnk)
{ 
	ChkArg(lnk, 2); 
	Remove(self); 
	AddAfter(lnk, self); 
	return self; 
} 



imeth objrtn Link_im_gMoveBefore(object self, object lnk)
{ 
	ChkArg(lnk, 2); 
	Remove(self); 
	AddBefore(lnk, self); 
	return self; 
} 

imeth objrtn Link_im_gStringRepValue(object self)
{ Link_iv_t *iv = GetIVs(Link, self);
	if (iv->iList && iv->iList == self) 
		return oSuper(Link_c, gStringRepValue, self)(self); 
	else 
		return vSprintf(String, "(<%8.8lx>, <%8.8lx>)", iv->iPrev, iv->iNext); 
} 

imeth objrtn Link_im_gStringRep(object self)
{ 
	object s, t; 

	s = oSuper(Link_c, gStringRep, self)(self); 
	t = gStringRepValue(self); 
	vBuild(s, NULL, t, "\n", NULL); 
	gDispose(t); 
	return s; 
} 

imeth objrtn Link_im_gCopy(object self)
{ 
	object nobj; 
	ivType *iv2; 

	nobj = oSuper(Link_c, gCopy, self)(self); 
	iv2 = ivPtr(nobj); 
	iv2->iList = iv2->iNext = iv2->iPrev = NULLOBJ; 
	return nobj; 
} 

imeth objrtn Link_im_gNth(object self, int idx)
{ 
	while (idx > 0 && self) { 
		self = gNext(self); 
		idx--; 
	} 
	while (idx < 0 && self) { 
		self = gPrevious(self); 
		idx++; 
	} 
	return idx ? NULLOBJ : self; 
} 


#line 282 "link.c"

objrtn	Link_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (Link_c) {
		LEAVECRITICALSECTION(cs);
		return Link_c;
	}
	INHIBIT_THREADER;
	Link_c = gNewClass(Class, "Link", sizeof(Link_iv_t), 0, END);
	iMethodFor(Link, gAddAfter, AddAfter);
	iMethodFor(Link, gInitLink, Link_im_gInitLink);
	iMethodFor(Link, gRemove, Remove);
	iMethodFor(Link, gMoveBeginning, Link_im_gMoveBeginning);
	iMethodFor(Link, gChangeNext, Link_im_gChangeNext);
	iMethodFor(Link, gMoveAfter, Link_im_gMoveAfter);
	iMethodFor(Link, gList, Link_im_gList);
	iMethodFor(Link, gNext, Link_im_gNext);
	iMethodFor(Link, gAddBefore, AddBefore);
	iMethodFor(Link, gDispose, Link_im_gDispose);
	iMethodFor(Link, gChangePrevious, Link_im_gChangePrevious);
	iMethodFor(Link, gMoveBefore, Link_im_gMoveBefore);
	iMethodFor(Link, gMoveEnd, Link_im_gMoveEnd);
	iMethodFor(Link, gStringRepValue, Link_im_gStringRepValue);
	iMethodFor(Link, gPrevious, Link_im_gPrevious);
	iMethodFor(Link, gCopy, Link_im_gCopy);
	iMethodFor(Link, gDeepDispose, Link_im_gDeepDispose);
	iMethodFor(Link, gStringRep, Link_im_gStringRep);
	iMethodFor(Link, gDeepCopy, Link_im_gCopy);
	iMethodFor(Link, gNth, Link_im_gNth);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return Link_c;
}



