
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


#include <math.h>

defclass  IntegerAssociation : Association  {
	int	iKey;
	iValue;
};

cmeth	gNewWithIntObj, <vNew> (int key, value)
{
	object	assoc;
	ivType	*iv;

	ChkArgNul(value, 3);
	assoc = gNew(super);
	iv = ivPtr(assoc);
	iKey = key;
	iValue = value;
	return assoc;
}

imeth	gDeepCopy()
{
	object	nobj;

	nobj = gDeepCopy(super);
	ivPtr(nobj)->iValue = iValue ? gDeepCopy(iValue) : NULL;
	return nobj;
}

imeth	gValue()
{
	return iValue;
}

imeth	gChangeValue(value)
{
	object	ret;
	ChkArgNul(value, 2);
	ret = iValue;
	iValue = value;
	return ret;
}

imeth	int	gIntKey()
{
	return iKey;
}

imeth	gChangeIntKey(int key)
{
	iKey = key;
	return self;
}

imeth	object	gDeepDispose()
{
	if (iValue)
		gDeepDispose(iValue);
	return gDispose(super);
}

imeth	gStringRepValue()
{
	object	s, t;

	t = iValue ? gStringRepValue(iValue) : gNewWithStr(String, "(null)");
	s = vSprintf(String, "( %d, ", iKey);
	vBuild(s, NULL, t, " )", NULL);
	gDispose(t);
	return s;
}

imeth	int	gHash()
{
	double	t;

	t = .6125423371	* (unsigned) iKey;
	t = t < 0.0 ? -t : t;
	return (int) (BIG_INT * (t - floor(t)));
}

imeth	int	gCompare(arg)
{
	int	sv, ov;

	ChkArg(arg, 2);
	if ((sv=iKey) < (ov=gIntKey(arg)))
		return -1;
	else if (sv == ov)
		return 0;
	else
		return 1;
}




/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

